/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.actions;

import io.intino.alexandria.http.server.AlexandriaHttpContext;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.schemas.Attribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.NodeDefinition;
import org.monet.space.kernel.components.ComponentPersistence;
import org.monet.space.kernel.components.layers.NodeLayer;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.map.Location;

public class GetLocationsFromNodeAction {
    public UnitBox box;
    public AlexandriaHttpContext context;
    public String id;

    public List<io.intino.goros.unit.box.schemas.Location> execute() {
        NodeLayer nodeLayer = ComponentPersistence.getInstance().getNodeLayer();
        if (this.id == null) {
            return null;
        }
        Node node = nodeLayer.loadNode(this.id);
        if (node == null) {
            return null;
        }
        String code = node.getCode();
        Location location = node.getLocation();
        ArrayList<Location> result = new ArrayList<Location>();
        result.add(location);
        NodeDefinition nodeDefinition = Dictionary.getInstance().getNodeDefinition(code);
        IndexDefinition indexDefinition = Dictionary.getInstance().locateIndex(nodeDefinition);
        return result.stream().map(l -> this.changeType((Location)l, indexDefinition)).collect(Collectors.toList());
    }

    private io.intino.goros.unit.box.schemas.Location changeType(Location l, IndexDefinition indexDefinition) {
        io.intino.goros.unit.box.schemas.Location result = new io.intino.goros.unit.box.schemas.Location();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Map.Entry entry : l.getAttributes().entrySet()) {
            Attribute attribute = new Attribute();
            attribute.name((String)entry.getKey());
            attribute.label(indexDefinition.getAttribute((String)entry.getKey()).getLabel().toString());
            attribute.value((String)entry.getValue());
            attributes.add(attribute);
        }
        result.attributes(attributes);
        result.name(l.getLabel());
        result.latitude(l.getGeometry().getCentroid().getCoordinate().x);
        result.longitude(l.getGeometry().getCentroid().getCoordinate().y);
        return result;
    }

    public void onMalformedRequest(Throwable e) {
    }
}

