/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.security.BasicAuthenticationValidator;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.AbstractBox;
import io.intino.goros.unit.box.GorosOAuthAccessor;
import io.intino.goros.unit.box.GorosUnit;
import io.intino.goros.unit.box.UnitConfiguration;
import io.intino.goros.unit.box.listeners.GorosUnitNotifier;
import io.intino.goros.unit.box.listeners.ListenerGoros;
import io.intino.goros.unit.util.LayerHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.monet.space.kernel.agents.AgentNotifier;
import org.monet.space.kernel.agents.AgentSession;
import org.monet.space.kernel.model.BusinessUnit;
import org.monet.space.kernel.model.Context;
import org.scribe.model.Token;

public class UnitBox
extends AbstractBox {
    private GorosUnitNotifier notifier;

    public UnitBox(String[] args) {
        super(args);
    }

    public UnitBox(UnitConfiguration configuration) {
        super(configuration);
    }

    public GorosUnitNotifier notifier() {
        return this.notifier;
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        return this;
    }

    @Override
    public void beforeStart() {
        this.notifier = new GorosUnitNotifier();
        this.listenMonet();
    }

    @Override
    public void afterStart() {
        this.pushService().onLinkToThread((client, session) -> this.linkSession((UISession)session));
        GorosUnit.open(this.normalize(this.configuration.args()));
    }

    @Override
    public void beforeStop() {
    }

    @Override
    public void afterStop() {
    }

    public void initSession(UISession session) {
        Context.getInstance().setApplication(Long.valueOf(Thread.currentThread().getId()), this.hostOf(session.browser().homeUrl()), this.configuration.name(), "UI");
        Context.getInstance().setUserServerConfig(Long.valueOf(Thread.currentThread().getId()), this.hostOf(session.browser().baseUrl()), session.browser().basePath(), Integer.valueOf(Integer.parseInt(this.configuration.port())));
        AgentSession.getInstance().add(session.id());
        this.linkSession(session);
        if (session.token() == null) {
            return;
        }
        Token token = new Token(session.token().id(), session.token().secret());
        LayerHelper.federationLayer(session).injectAccessToken(token);
    }

    public void linkSession(UISession session) {
        Context.getInstance().setSessionId(Long.valueOf(Thread.currentThread().getId()), session.id());
    }

    public BusinessUnit businessUnit() {
        return BusinessUnit.getInstance();
    }

    @Override
    protected AuthService authService(URL authServiceUrl) {
        return new GorosOAuthAccessor(this);
    }

    public BasicAuthenticationValidator authenticationValidator() {
        return token -> token != null && !token.isEmpty() && this.loadAuthenticationTokens().contains(token);
    }

    public boolean isInstalled() {
        return GorosUnit.isInstalled(this.normalize(this.configuration.args()));
    }

    private void listenMonet() {
        AgentNotifier.getInstance().register("Goros", ListenerGoros.class);
        ListenerGoros listener = (ListenerGoros)AgentNotifier.getInstance().get("Goros");
        listener.inject(this.notifier);
    }

    private Map<String, String> normalize(Map<String, String> parameters) {
        return parameters.entrySet().stream().collect(Collectors.toMap(e -> this.normalizeParameterName((String)e.getKey()), Map.Entry::getValue));
    }

    private String normalizeParameterName(String key) {
        if (key.equals("jdbc-datasource")) {
            return "Jdbc.DataSource";
        }
        if (key.equals("jdbc-type")) {
            return "Jdbc.Type";
        }
        if (key.equals("jdbc-max-active-connections")) {
            return "Jdbc.MaxActiveConnections";
        }
        if (key.equals("jdbc-max-idle-connections")) {
            return "Jdbc.MaxIdleConnections";
        }
        if (key.equals("jdbc-remove-abandoned-timeout")) {
            return "Jdbc.RemoveAbandonedTimeout";
        }
        if (key.equals("jdbc-url")) {
            return "Jdbc.Url";
        }
        if (key.equals("jdbc-user")) {
            return "Jdbc.User";
        }
        if (key.equals("jdbc-password")) {
            return "Jdbc.Password";
        }
        return "MONET_" + key.toUpperCase().replace("-", "_");
    }

    private String hostOf(String url) {
        try {
            return new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private List<String> loadAuthenticationTokens() {
        try {
            if (!this.configuration.servicesAuthenticationTokens().isEmpty()) {
                return List.of(this.configuration.servicesAuthenticationTokens().split(";"));
            }
            Path path = Path.of(this.configuration.servicesAuthenticationTokensFilename(), new String[0]);
            if (!path.toFile().exists()) {
                return Collections.emptyList();
            }
            return Files.readAllLines(Path.of(this.configuration.servicesAuthenticationTokensFilename(), new String[0]));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Collections.emptyList();
        }
    }
}

