/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.restaccessor.RestAccessor;
import io.intino.alexandria.restaccessor.exceptions.RestfulFailure;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.FederationInfo;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.alexandria.ui.services.auth.UserInfo;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotInvalidateAccessToken;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotLogout;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAccessToken;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAuthorizationUrl;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainRequestToken;
import io.intino.alexandria.ui.services.auth.exceptions.SpaceAuthCallbackUrlIsNull;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.util.LayerHelper;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.monet.federation.accountservice.accountactions.impl.messagemodel.FederationAccount;
import org.monet.metamodel.Distribution;
import org.monet.space.kernel.components.ComponentFederation;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class GorosOAuthAccessor
implements AuthService {
    private final UnitBox box;
    private final RestAccessor api;
    private Space space;

    public GorosOAuthAccessor(UnitBox box) {
        this.box = box;
        this.api = new io.intino.alexandria.restaccessor.core.RestAccessor();
    }

    public URL url() {
        return this.urlOf(this.box.businessUnit().getFederation().getUri());
    }

    public Space space() {
        if (this.space != null) {
            return this.space;
        }
        Distribution distribution = this.box.businessUnit().getDistribution();
        URL baseUrl = distribution != null && distribution.getSpace() != null ? this.urlOf(distribution.getSpace().getDeployUri()) : this.urlOf(this.box.configuration.servicesBaseUrl());
        this.space = new Space(this.url());
        this.space.name(this.box.configuration().name());
        this.space.secret(this.box.configuration().certificatePassword());
        this.space.setBaseUrl(baseUrl != null ? baseUrl.toString() : this.box.configuration().servicesBaseUrl());
        return this.space;
    }

    public AuthService.Authentication authenticate() throws SpaceAuthCallbackUrlIsNull {
        return new AuthService.Authentication(){
            private OAuthService authService;
            private io.intino.alexandria.ui.services.auth.Token requestToken;
            private io.intino.alexandria.ui.services.auth.Token accessToken;

            public io.intino.alexandria.ui.services.auth.Token requestToken() throws CouldNotObtainRequestToken {
                try {
                    this.requestToken = GorosOAuthAccessor.this.tokenFrom(Optional.of(this.authService().getRequestToken()));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainRequestToken(exception);
                }
                catch (SpaceAuthCallbackUrlIsNull e) {
                    Logger.error((Throwable)e);
                    throw new RuntimeException(e);
                }
                this.accessToken = null;
                return this.requestToken;
            }

            public URL authenticationUrl(io.intino.alexandria.ui.services.auth.Token requestToken) throws CouldNotObtainAuthorizationUrl {
                if (this.requestToken != requestToken) {
                    return null;
                }
                try {
                    return new URL(this.authService().getAuthorizationUrl(GorosOAuthAccessor.this.token(Optional.of(requestToken))));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainAuthorizationUrl(exception);
                }
                catch (SpaceAuthCallbackUrlIsNull e) {
                    Logger.error((Throwable)e);
                    throw new RuntimeException(e);
                }
            }

            public io.intino.alexandria.ui.services.auth.Token accessToken() {
                return this.accessToken;
            }

            public io.intino.alexandria.ui.services.auth.Token accessToken(io.intino.alexandria.ui.services.auth.Verifier verifier) throws CouldNotObtainAccessToken {
                if (this.requestToken == null) {
                    return null;
                }
                try {
                    Token accessToken = this.authService().getAccessToken(GorosOAuthAccessor.this.token(Optional.of(this.requestToken)), GorosOAuthAccessor.this.verifier(verifier));
                    this.accessToken = GorosOAuthAccessor.this.tokenFrom(Optional.of(accessToken));
                }
                catch (Exception e) {
                    throw new CouldNotObtainAccessToken(e);
                }
                catch (SpaceAuthCallbackUrlIsNull e) {
                    Logger.error((Throwable)e);
                    throw new RuntimeException(e);
                }
                return this.accessToken;
            }

            public void invalidate() throws CouldNotInvalidateAccessToken {
                try {
                    ComponentFederation.getInstance().getFederationService().logout(this.accessToken.id(), LayerHelper.defaultRequest());
                }
                catch (Exception e) {
                    throw new CouldNotInvalidateAccessToken(e);
                }
            }

            public AuthService.Authentication.Version version() {
                return AuthService.Authentication.Version.OAuth2;
            }

            private OAuthService authService() throws SpaceAuthCallbackUrlIsNull {
                if (this.authService == null) {
                    this.authService = GorosOAuthAccessor.this.serviceOf(GorosOAuthAccessor.this.url(), GorosOAuthAccessor.this.space());
                }
                return this.authService;
            }
        };
    }

    public boolean valid(io.intino.alexandria.ui.services.auth.Token accessToken) {
        try {
            if (accessToken == null) {
                return false;
            }
            return ComponentFederation.getInstance().getFederationService().isLogged(accessToken.id(), LayerHelper.defaultRequest());
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    public FederationInfo info(io.intino.alexandria.ui.services.auth.Token accessToken) throws CouldNotObtainInfo {
        try {
            final org.monet.federation.accountservice.accountactions.impl.messagemodel.FederationInfo info = ComponentFederation.getInstance().getFederationService().getInfo();
            return new FederationInfo(){

                public String name() {
                    return info.getName();
                }

                public String title() {
                    return info.getLabel();
                }

                public String subtitle() {
                    return null;
                }

                public URL logo() {
                    try {
                        return new URL(info.getLogoPath());
                    }
                    catch (MalformedURLException ignored) {
                        return null;
                    }
                }

                public URI pushServerUri() {
                    return null;
                }
            };
        }
        catch (Exception exception) {
            throw new CouldNotObtainInfo(exception);
        }
    }

    public UserInfo me(io.intino.alexandria.ui.services.auth.Token accessToken) throws CouldNotObtainInfo {
        try {
            final FederationAccount account = ComponentFederation.getInstance().getFederationService().getAccount(accessToken.id(), LayerHelper.defaultRequest());
            return new UserInfo(){

                public String username() {
                    return account.getUsername();
                }

                public String fullName() {
                    return account.getFullname();
                }

                public URL photo() {
                    return null;
                }

                public String email() {
                    return account.getEmail();
                }

                public String language() {
                    return account.getLang();
                }

                public List<String> roleList() {
                    return Collections.emptyList();
                }
            };
        }
        catch (Exception exception) {
            throw new CouldNotObtainInfo(exception);
        }
    }

    public void logout(io.intino.alexandria.ui.services.auth.Token accessToken) throws CouldNotLogout {
        try {
            this.api.post(this.url(), String.format("/api/logout/%s", accessToken.id()));
        }
        catch (Exception exception) {
            throw new CouldNotLogout(exception);
        }
    }

    public String logoutUrl() {
        return "/api/logout";
    }

    public void addPushListener(io.intino.alexandria.ui.services.auth.Token accessToken, AuthService.FederationNotificationListener listener) throws CouldNotObtainInfo {
    }

    private io.intino.alexandria.ui.services.auth.Token tokenFrom(final Optional<Token> token) {
        if (!token.isPresent()) {
            return null;
        }
        return new io.intino.alexandria.ui.services.auth.Token(){

            public String id() {
                return ((Token)token.get()).getToken();
            }

            public String secret() {
                return ((Token)token.get()).getSecret();
            }
        };
    }

    private Token token(Optional<io.intino.alexandria.ui.services.auth.Token> token) {
        if (!token.isPresent()) {
            return null;
        }
        return new Token(token.get().id(), token.get().secret());
    }

    private Verifier verifier(io.intino.alexandria.ui.services.auth.Verifier verifier) {
        return new Verifier(verifier.value());
    }

    private OAuthService serviceOf(URL federation, Space space) throws SpaceAuthCallbackUrlIsNull {
        ServiceBuilder builder = new ServiceBuilder().provider(this.apiOf(federation)).apiKey(space.name()).apiSecret(space.secret());
        URL callbackUrl = space.authCallbackUrl();
        if (callbackUrl == null) {
            throw new SpaceAuthCallbackUrlIsNull();
        }
        builder.callback(callbackUrl.toString());
        return builder.build();
    }

    private Api apiOf(URL federation) {
        String AuthenticationPath = "/accounts/authorization/?oauth_token=%s";
        String RequestTokenPath = "/accounts/tokens/request/";
        String AccessTokenPath = "/accounts/tokens/access/";
        final String url = federation.toString();
        return new DefaultApi10a(){

            public String getRequestTokenEndpoint() {
                return url + "/accounts/tokens/request/";
            }

            public String getAccessTokenEndpoint() {
                return url + "/accounts/tokens/access/";
            }

            public String getAuthorizationUrl(Token token) {
                return url + String.format("/accounts/authorization/?oauth_token=%s", token.getToken());
            }
        };
    }

    private boolean getAndCheck(URL url, String resource) throws RestfulFailure {
        return Boolean.valueOf(this.api.get(url, resource).content());
    }

    private URL urlOf(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private URL urlOf(String uri) {
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

