package io.intino.goros.unit.box.ui.resources;

import io.intino.goros.unit.box.UnitBox;

import io.intino.goros.unit.box.ui.pages.BannerPage;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.pages.UiPage;
import io.intino.alexandria.ui.services.push.UIClient;

import java.util.Base64;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class BannerResource extends io.intino.alexandria.ui.server.resources.Resource {
	private final UnitBox box;

	public BannerResource(UnitBox box, io.intino.alexandria.ui.server.AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
		this.box = box;
	}

	@Override
	public void execute() throws AlexandriaException {
		super.execute();
		fillDeviceParameter();
		render();
	}

	private void render() {
		String clientId = UUID.randomUUID().toString();
		UiPage page = new BannerPage();
		page.session = manager.currentSession();
		page.session.browser().onRedirect(location -> manager.redirect(location));
		page.session.browser().requestUrl(manager.requestUrl());
		page.session.whenLogin(new Function<String, String>() {
			@Override
			public String apply(String baseUrl) {
				return BannerResource.this.authenticate(page.session, baseUrl);
			}
		});
		page.session.whenLogout(b -> logout(page.session));
        ((BannerPage)page).box = box;
		page.clientId = clientId;
		page.webDirectories = manager.webDirectories();
		page.device = parameterValue("device");
		page.token = parameterValue("token");
		((BannerPage)page).view = parameterValue("view");
		if (!page.hasPermissions()) {
			manager.redirect(page.redirectUrl());
			return;
		}

		manager.pushService().onOpen(client -> {
			if (!client.id().equals(page.clientId))
				return false;

			if (client.soul() != null && box.routeManager().routeDispatcher() instanceof io.intino.goros.unit.box.ui.displays.RouteDispatcher) {
				((io.intino.goros.unit.box.ui.displays.RouteDispatcher)box.routeManager().routeDispatcher()).dispatchBanner(client.soul(), ((BannerPage)page).view);
				return false;
			}

			io.intino.alexandria.ui.Soul soul = page.prepareSoul(client);
			soul.onRedirect((location) -> manager.redirect(location));
			soul.addRegisterDisplayListener(display -> {
				display.inject(notifier(page.session, client, display));
				display.inject(page.session);
				display.inject(soul);
				display.inject(() -> soul);
			});
			((UIClient)client).soul(soul);
			client.cookies(manager.cookies());

			box.registerSoul(clientId, soul);
			soul.register(new io.intino.alexandria.ui.displays.DisplayRouter(box).id("__router__"));
			if (box.routeManager().routeDispatcher() instanceof io.intino.goros.unit.box.ui.displays.RouteDispatcher)
			    ((io.intino.goros.unit.box.ui.displays.RouteDispatcher)box.routeManager().routeDispatcher()).dispatchBanner(soul, ((BannerPage)page).view);

			return true;
		});

		manager.pushService().onClose(clientId).execute(new Consumer<io.intino.alexandria.ui.services.push.UIClient>() {
			@Override
			public void accept(io.intino.alexandria.ui.services.push.UIClient client) {
				box.soul(client.id()).ifPresent(s -> s.destroy());
				box.unRegisterSoul(client.id());
				manager.unRegister(client);
			}
		});

		manager.write(page.execute());
	}

}