package io.intino.goros.unit.box.rest.resources;

import java.util.List;
import java.util.Set;
import java.util.ArrayList;
import io.intino.alexandria.exceptions.*;
import io.intino.goros.unit.box.*;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.*;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.http.pushservice.PushService;

import io.intino.goros.unit.box.schemas.*;

public class PostUploadTaskFileResource implements Resource {

	private UnitBox box;
	private AlexandriaHttpManager<PushService<?,?>> manager;

	public PostUploadTaskFileResource(UnitBox box, AlexandriaHttpManager manager) {
		this.box = box;
		this.manager = manager;
	}

	public void execute() throws AlexandriaException {
		write(fill(new io.intino.goros.unit.box.actions.PostUploadTaskFileAction()).execute());
	}

	private io.intino.goros.unit.box.actions.PostUploadTaskFileAction fill(io.intino.goros.unit.box.actions.PostUploadTaskFileAction action) throws AlexandriaException {
		action.box = this.box;
		action.context = context();
		try {
			action.request = new io.intino.alexandria.Resource("request", manager.fromBodyAsBytes());
			action.id = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromPath("id"), String.class);
			action.extra = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromPath("extra"), String.class);
		} catch (Throwable e) {
			action.onMalformedRequest(e);
		}
		return action;
	}

	private void write(io.intino.alexandria.Resource object) {
		manager.write(object);
	}

	private io.intino.alexandria.http.server.AlexandriaHttpContext context() {
		io.intino.alexandria.http.server.AlexandriaHttpContext context = new io.intino.alexandria.http.server.AlexandriaHttpContext(manager);

		context.put("pathInfo", manager.request().raw().getPathInfo());
		context.put("ip", manager.ip());
		return context;
	}
}