package io.intino.goros.unit.box.rest.resources;

import java.util.List;
import java.util.Set;
import java.util.ArrayList;
import io.intino.alexandria.exceptions.*;
import io.intino.goros.unit.box.*;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.*;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.http.pushservice.PushService;

import io.intino.goros.unit.box.schemas.*;

public class PostAddSourceTermResource implements Resource {

	private UnitBox box;
	private AlexandriaHttpManager<PushService<?,?>> manager;

	public PostAddSourceTermResource(UnitBox box, AlexandriaHttpManager manager) {
		this.box = box;
		this.manager = manager;
	}

	public void execute() throws AlexandriaException {
		write(fill(new io.intino.goros.unit.box.actions.PostAddSourceTermAction()).execute());
	}

	private io.intino.goros.unit.box.actions.PostAddSourceTermAction fill(io.intino.goros.unit.box.actions.PostAddSourceTermAction action) throws AlexandriaException {
		action.box = this.box;
		action.context = context();
		try {
			action.code = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("code"), String.class);
			action.parent = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("parent"), String.class);
			action.type = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("type"), String.class);
			action.source = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("source"), String.class);
			action.label = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("label"), String.class);
			action.tags = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("tags"), String.class);
		} catch (Throwable e) {
			action.onMalformedRequest(e);
		}
		return action;
	}

	private void write(String object) {
		manager.write(io.intino.alexandria.rest.ResponseAdapter.adapt(object));
	}

	private io.intino.alexandria.http.server.AlexandriaHttpContext context() {
		io.intino.alexandria.http.server.AlexandriaHttpContext context = new io.intino.alexandria.http.server.AlexandriaHttpContext(manager);

		context.put("pathInfo", manager.request().raw().getPathInfo());
		context.put("ip", manager.ip());
		return context;
	}
}