package io.intino.goros.unit.printers.templates;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.*;
import static io.intino.itrules.template.outputs.Outputs.*;

public class PdfNodeTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(allTypes("node")).output(literal("<?xml version='1.0' encoding='UTF-8'?>\n<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n\n  <fo:layout-master-set>\n    <fo:simple-page-master master-name=\"cover\" page-height=\"29.7cm\" page-width=\"21cm\" margin-top=\"1cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n      <fo:region-body margin-top=\"10cm\" />\n    </fo:simple-page-master>\n\n    <fo:simple-page-master master-name=\"page-portrait\" page-height=\"29.7cm\" page-width=\"21cm\" margin-top=\"1cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n      <fo:region-body margin-top=\"1cm\" margin-bottom=\"1cm\"/>\n      <fo:region-before precedence=\"true\" extent=\"1cm\"/>\n      <fo:region-after precedence=\"true\" extent=\"0.5cm\"/>\n      <fo:region-start extent=\"1cm\"/>\n      <fo:region-end extent=\"1cm\"/>\n    </fo:simple-page-master>\n\n    <fo:simple-page-master master-name=\"page-landscape\" page-height=\"21cm\" page-width=\"29.7cm\" margin-top=\"1cm\" margin-bottom=\"2cm\" margin-left=\"1cm\" margin-right=\"1cm\">\n      <fo:region-body margin-top=\"1cm\" margin-bottom=\"1cm\"/>\n      <fo:region-before precedence=\"true\" extent=\"1cm\"/>\n      <fo:region-after precedence=\"true\" extent=\"0.5cm\"/>\n      <fo:region-start extent=\"1cm\"/>\n      <fo:region-end extent=\"1cm\"/>\n    </fo:simple-page-master>\n\n    <fo:simple-page-master master-name=\"section\" page-height=\"29.7cm\" page-width=\"21cm\" margin-top=\"1cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n      <fo:region-body margin-top=\"10cm\" />\n    </fo:simple-page-master>\n  </fo:layout-master-set>\n\n  <fo:page-sequence master-reference=\"page-")).output(placeholder("orientation")).output(literal("\">\n    <fo:static-content flow-name=\"xsl-region-before\">\n      <fo:block text-align=\"end\" font-size=\"10pt\" font-family=\"serif\" line-height=\"14pt\" color=\"#555\"></fo:block>\n    </fo:static-content>\n\n    <fo:static-content flow-name=\"xsl-region-after\">\n      <fo:block text-align=\"end\" font-size=\"10pt\" font-family=\"serif\" line-height=\"14pt\" color=\"#555\" border-top=\"0.5pt solid #555\">")).output(placeholder("label")).output(literal(" - ")).output(placeholder("pageLabel")).output(literal(" <fo:page-number/></fo:block>\n    </fo:static-content>\n\n    <fo:static-content flow-name=\"xsl-region-start\">\n      <fo:block-container height=\"22.2cm\" width=\"1cm\" top=\"0cm\" left=\"0cm\" position=\"absolute\">\n        <fo:block text-align=\"start\"></fo:block>\n      </fo:block-container>\n    </fo:static-content>\n\n    <fo:static-content flow-name=\"xsl-region-end\">\n      <fo:block-container height=\"22.2cm\" width=\"1cm\" top=\"0cm\" left=\"0cm\" position=\"absolute\">\n        <fo:block text-align=\"start\"></fo:block>\n      </fo:block-container>\n    </fo:static-content>\n\n    <fo:flow flow-name=\"xsl-region-body\">")).output(placeholder("content")).output(literal("</fo:flow>\n\n  </fo:page-sequence>\n</fo:root>")));
		rules.add(rule().condition(allTypes("content", "empty")).output(literal("<fo:block font-size=\"20pt\">")).output(placeholder("label")).output(literal("</fo:block>\n<fo:block font-size=\"10pt\" margin-bottom=\"3mm\" color=\"#666666\">")).output(placeholder("date")).output(literal("</fo:block>\n")).output(placeholder("filters")).output(literal("\n<fo:block>")).output(placeholder("noElementsMessage")).output(literal("</fo:block>")));
		rules.add(rule().condition(allTypes("content")).output(literal("<fo:block font-size=\"20pt\">")).output(placeholder("label")).output(literal("</fo:block>\n<fo:block font-size=\"10pt\" margin-bottom=\"2mm\" color=\"#666666\">")).output(placeholder("date")).output(literal("</fo:block>\n")).output(placeholder("filters")).output(literal("\n<fo:block margin-bottom=\"6mm\"></fo:block>\n<fo:table table-layout=\"fixed\">\n    ")).output(placeholder("header", "columns")).output(literal("\n    <fo:table-header>")).output(placeholder("header")).output(literal("</fo:table-header>\n    <fo:table-body>")).output(placeholder("references")).output(literal("</fo:table-body>\n</fo:table>")));
		rules.add(rule().condition(allTypes("filters", "empty")));
		rules.add(rule().condition(allTypes("filters")).output(literal("<fo:block background-color=\"#FAEDC3\" font-size=\"12pt\" margin-bottom=\"2mm\" padding=\"1mm\">\n    ")).output(placeholder("filtersMessage")).output(literal("\n    ")).output(expression().output(placeholder("filter").multiple("\n"))).output(literal("\n</fo:block>")));
		rules.add(rule().condition(allTypes("filter", "lt")).output(literal("<fo:block font-size=\"9pt\" margin-left=\"4mm\">")).output(placeholder("label")).output(literal(" anterior a ")).output(expression().output(placeholder("value").multiple(", "))).output(literal(", inclusive</fo:block>")));
		rules.add(rule().condition(allTypes("filter", "gt")).output(literal("<fo:block font-size=\"9pt\" margin-left=\"4mm\">")).output(placeholder("label")).output(literal(" posterior a ")).output(expression().output(placeholder("value").multiple(", "))).output(literal(", inclusive</fo:block>")));
		rules.add(rule().condition(allTypes("filter")).output(literal("<fo:block font-size=\"9pt\" margin-left=\"4mm\">")).output(placeholder("label")).output(literal(": ")).output(expression().output(placeholder("value").multiple(", "))).output(literal("</fo:block>")));
		rules.add(rule().condition(all(allTypes("header"), trigger("columns"))).output(expression().output(placeholder("reference", "column").multiple("\n"))));
		rules.add(rule().condition(allTypes("header")).output(expression().output(placeholder("reference", "header").multiple("\n"))));
		rules.add(rule().condition(allTypes("references")).output(expression().output(placeholder("reference").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("reference"), trigger("column"))).output(expression().output(placeholder("attribute", "column").multiple("\n"))).output(literal("\n<fo:table-column column-width=\"")).output(placeholder("width")).output(literal("%\"/>")));
		rules.add(rule().condition(all(allTypes("reference"), trigger("header"))).output(literal("<fo:table-row background-color=\"#EFF7FF\" margin-bottom=\"2mm\" border-top=\"0.2mm solid #5E93B1\" border-bottom=\"0.1mm solid #5E93B1\">\n    ")).output(expression().output(placeholder("attribute", "header").multiple("\n"))).output(literal("\n</fo:table-row>")));
		rules.add(rule().condition(allTypes("reference")).output(literal("<fo:table-row")).output(expression().output(literal(" background-color=\"#ddd\"")).output(placeholder("odd", "empty"))).output(literal(">\n    ")).output(expression().output(placeholder("attribute").multiple("\n"))).output(literal("\n</fo:table-row>")));
		rules.add(rule().condition(all(allTypes("attribute"), trigger("column"))).output(literal("<fo:table-column column-width=\"")).output(placeholder("width")).output(literal("%\"/>")));
		rules.add(rule().condition(all(allTypes("attribute"), trigger("header"))).output(literal("<fo:table-cell padding-left=\"0.5mm\" padding-top=\"2mm\" padding-bottom=\"2mm\" wrap-option=\"wrap\">\n    <fo:block font-size=\"10pt\" font-weight=\"bold\">")).output(placeholder("label")).output(literal("</fo:block>\n</fo:table-cell>")));
		rules.add(rule().condition(allTypes("attribute", "picture")).output(literal("<fo:table-cell padding-left=\"0.5mm\" font-size=\"8pt\" padding-top=\"2mm\" padding-bottom=\"2mm\"><fo:block><fo:external-graphic src=\"url('")).output(placeholder("value")).output(literal("')\" content-height=\"scale-to-fit\" height=\"1.00in\" content-width=\"1.00in\" scaling=\"non-uniform\"/></fo:block></fo:table-cell>")));
		rules.add(rule().condition(allTypes("attribute")).output(literal("<fo:table-cell padding-left=\"0.5mm\" font-size=\"8pt\" padding-top=\"2mm\" padding-bottom=\"2mm\"><fo:block>")).output(placeholder("value")).output(literal("</fo:block></fo:table-cell>")));
		rules.add(rule().condition(all(allTypes("odd"), trigger("empty"))));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}