package io.intino.goros.unit.box.rest.resources;

import java.util.List;
import java.util.Set;
import java.util.ArrayList;
import io.intino.alexandria.exceptions.*;
import io.intino.goros.unit.box.*;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.*;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.http.pushservice.PushService;

import io.intino.goros.unit.box.schemas.*;

public class PostBusinessResource implements Resource {

	private UnitBox box;
	private AlexandriaHttpManager<PushService<?,?>> manager;

	public PostBusinessResource(UnitBox box, AlexandriaHttpManager manager) {
		this.box = box;
		this.manager = manager;
	}

	public void execute() throws AlexandriaException {
		write(fill(new io.intino.goros.unit.box.actions.PostBusinessAction()).execute());
	}

	private io.intino.goros.unit.box.actions.PostBusinessAction fill(io.intino.goros.unit.box.actions.PostBusinessAction action) throws AlexandriaException {
		action.box = this.box;
		action.context = context();
		try {
			action.service = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromPath("service"), String.class);
			action.sourceUnit = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("source-unit"), String.class);
			action.replyMailbox = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("reply-mailbox"), String.class);
			action.startDate = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("start-date"), String.class);
			action.endDate = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("end-date"), String.class);
			action.comments = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("comments"), String.class);
			action.urgent = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("urgent"), String.class);
		} catch (Throwable e) {
			action.onMalformedRequest(e);
		}
		return action;
	}

	private void write(String object) {
		manager.write(io.intino.alexandria.rest.ResponseAdapter.adapt(object));
	}

	private io.intino.alexandria.http.server.AlexandriaHttpContext context() {
		io.intino.alexandria.http.server.AlexandriaHttpContext context = new io.intino.alexandria.http.server.AlexandriaHttpContext(manager);

		context.put("pathInfo", manager.request().raw().getPathInfo());
		context.put("ip", manager.ip());
		return context;
	}
}