package io.intino.goros.unit.box.rest.resources;

import java.util.List;
import java.util.Set;
import java.util.ArrayList;
import io.intino.alexandria.exceptions.*;
import io.intino.goros.unit.box.*;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.*;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.http.pushservice.PushService;

import io.intino.goros.unit.box.schemas.*;

public class GetLocationsFromNodeResource implements Resource {

	private UnitBox box;
	private AlexandriaHttpManager<PushService<?,?>> manager;

	public GetLocationsFromNodeResource(UnitBox box, AlexandriaHttpManager manager) {
		this.box = box;
		this.manager = manager;
	}

	public void execute() throws AlexandriaException {
		write(fill(new io.intino.goros.unit.box.actions.GetLocationsFromNodeAction()).execute());
	}

	private io.intino.goros.unit.box.actions.GetLocationsFromNodeAction fill(io.intino.goros.unit.box.actions.GetLocationsFromNodeAction action) throws AlexandriaException {
		action.box = this.box;
		action.context = context();
		try {
			action.id = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromPath("id"), String.class);
		} catch (Throwable e) {
			action.onMalformedRequest(e);
		}
		return action;
	}

	private void write(List<Location> object) {
		manager.write(io.intino.alexandria.rest.ResponseAdapter.adapt(object), "application/json");
	}

	private io.intino.alexandria.http.server.AlexandriaHttpContext context() {
		io.intino.alexandria.http.server.AlexandriaHttpContext context = new io.intino.alexandria.http.server.AlexandriaHttpContext(manager);
		context.put("Authorization", manager.fromHeader("Authorization") != null ? manager.fromHeader("Authorization").replace("Bearer ", "") : null);
		context.put("pathInfo", manager.request().raw().getPathInfo());
		context.put("ip", manager.ip());
		return context;
	}
}