package io.intino.goros.unit.box.rest.resources;

import java.util.List;
import java.util.Set;
import java.util.ArrayList;
import io.intino.alexandria.exceptions.*;
import io.intino.goros.unit.box.*;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.*;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.http.pushservice.PushService;

import io.intino.goros.unit.box.schemas.*;

public class GetFmsServiceDispatcherResource implements Resource {

	private UnitBox box;
	private AlexandriaHttpManager<PushService<?,?>> manager;

	public GetFmsServiceDispatcherResource(UnitBox box, AlexandriaHttpManager manager) {
		this.box = box;
		this.manager = manager;
	}

	public void execute() throws AlexandriaException {
		write(fill(new io.intino.goros.unit.box.actions.GetFmsServiceDispatcherAction()).execute());
	}

	private io.intino.goros.unit.box.actions.GetFmsServiceDispatcherAction fill(io.intino.goros.unit.box.actions.GetFmsServiceDispatcherAction action) throws AlexandriaException {
		action.box = this.box;
		action.context = context();
		try {
			action.op = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("op"), String.class);
			action.id = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("id"), String.class);
			action.nid = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("nid"), String.class);
			action.f = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("f"), String.class);
			action.thumb = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("thumb"), String.class);
		} catch (Throwable e) {
			action.onMalformedRequest(e);
		}
		return action;
	}

	private void write(io.intino.alexandria.Resource object) {
		manager.write(object);
	}

	private io.intino.alexandria.http.server.AlexandriaHttpContext context() {
		io.intino.alexandria.http.server.AlexandriaHttpContext context = new io.intino.alexandria.http.server.AlexandriaHttpContext(manager);

		context.put("pathInfo", manager.request().raw().getPathInfo());
		context.put("ip", manager.ip());
		return context;
	}
}