package io.intino.goros.unit.box;

import io.intino.alexandria.http.AlexandriaHttpServer;
import io.intino.goros.unit.box.rest.resources.*;
import io.intino.alexandria.core.Box;

public class SetupServiceService {

	private static SetupServiceServiceAuthenticator authenticator;

	public static AlexandriaHttpServer setup(AlexandriaHttpServer server, UnitBox box) {
		authenticator = new SetupServiceServiceAuthenticator(box);
		server.route("setupservice/showapi").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostShowApiResource(box, manager).execute());
		server.route("setupservice/getmajorversion").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetMajorVersionResource(box, manager).execute());
		server.route("setupservice/getstatus").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostGetStatusResource(box, manager).execute());
		server.route("setupservice/run").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostRunResource(box, manager).execute());
		server.route("setupservice/putlabel").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostPutLabelResource(box, manager).execute());
		server.route("setupservice/putlogo").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostPutLogoResource(box, manager).execute());
		server.route("setupservice/stop").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostStopResource(box, manager).execute());
		server.route("setupservice/updatemodel").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostUpdateModelResource(box, manager).execute());
		server.route("setupservice/executeconstructor").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostExecuteConstructorResource(box, manager).execute());

		return server;
	}
}