package io.intino.goros.unit.box;

import io.intino.alexandria.http.AlexandriaHttpServer;
import io.intino.goros.unit.box.rest.resources.*;
import io.intino.alexandria.core.Box;

public class GeoServiceService {

	private static GeoServiceServiceAuthenticator authenticator;

	public static AlexandriaHttpServer setup(AlexandriaHttpServer server, UnitBox box) {
		authenticator = new GeoServiceServiceAuthenticator(box);
		server.route("1.0/api/geoservice/definitions").before(manager -> { if (manager.fromHeader("Authorization") == null || !authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).get(manager -> new GetDefinitionsResource(box, manager).execute());
		server.route("1.0/api/geoservice/locations/:name").before(manager -> { if (manager.fromHeader("Authorization") == null || !authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).get(manager -> new GetLocationsResource(box, manager).execute());
		server.route("1.0/api/geoservice/locations/:name/:owner").before(manager -> { if (manager.fromHeader("Authorization") == null || !authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).get(manager -> new GetLocationsByOwnerResource(box, manager).execute());
		server.route("1.0/api/geoservice/location/:id").before(manager -> { if (manager.fromHeader("Authorization") == null || !authenticator.isAuthenticated(manager.fromHeader("Authorization").replace("Bearer ", ""))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).get(manager -> new GetLocationsFromNodeResource(box, manager).execute());
		server.route("1.0/api/geoservice/image/:id/*").get(manager -> new GetImagesResource(box, manager).execute());

		return server;
	}
}