package io.intino.goros.unit.box.rest.resources;

import java.util.List;
import java.util.Set;
import java.util.ArrayList;
import io.intino.alexandria.exceptions.*;
import io.intino.goros.unit.box.*;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.*;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.http.pushservice.PushService;

import io.intino.goros.unit.box.schemas.*;

public class PostLocateNodeResource implements Resource {

	private UnitBox box;
	private AlexandriaHttpManager<PushService<?,?>> manager;

	public PostLocateNodeResource(UnitBox box, AlexandriaHttpManager manager) {
		this.box = box;
		this.manager = manager;
	}

	public void execute() throws AlexandriaException {
		write(fill(new io.intino.goros.unit.box.actions.PostLocateNodeAction()).execute());
	}

	private io.intino.goros.unit.box.actions.PostLocateNodeAction fill(io.intino.goros.unit.box.actions.PostLocateNodeAction action) throws AlexandriaException {
		action.box = this.box;
		action.context = context();
		try {
			action.code = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("code"), String.class);
			action.depth = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("depth"), String.class);
		} catch (Throwable e) {
			action.onMalformedRequest(e);
		}
		return action;
	}

	private void write(String object) {
		manager.write(io.intino.alexandria.rest.ResponseAdapter.adapt(object));
	}

	private io.intino.alexandria.http.server.AlexandriaHttpContext context() {
		io.intino.alexandria.http.server.AlexandriaHttpContext context = new io.intino.alexandria.http.server.AlexandriaHttpContext(manager);

		context.put("pathInfo", manager.request().raw().getPathInfo());
		context.put("ip", manager.ip());
		return context;
	}
}