package io.intino.goros.unit.box;

import io.intino.alexandria.http.AlexandriaHttpServer;
import io.intino.goros.unit.box.rest.resources.*;
import io.intino.alexandria.core.Box;

public class FrontServiceService {

	private static FrontServiceServiceAuthenticator authenticator;

	public static AlexandriaHttpServer setup(AlexandriaHttpServer server, UnitBox box) {
		authenticator = new FrontServiceServiceAuthenticator(box);
		server.route("service/source/:source/").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostSourceResource(box, manager).execute());
		server.route("service/mailbox/:address/").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostMailboxResource(box, manager).execute());
		server.route("service/business/:service/").before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized("Credential not found");}).post(manager -> new PostBusinessResource(box, manager).execute());

		return server;
	}
}