import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTable from "alexandria-ui-elements/src/displays/components/Table";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import DisplaysLinksOutTableRow from "unit-elements/gen/displays/rows/LinksOutTableRow";
import DisplaysLinksOutTableLabelItem from "unit-elements/gen/displays/items/LinksOutTableLabelItem";
import DisplaysLinksOutTableDescriptionItem from "unit-elements/gen/displays/items/LinksOutTableDescriptionItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import NodeLinksOutTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import NodeLinksOutTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class NodeLinksOutTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new NodeLinksOutTemplateNotifier(this);
		this.requester = new NodeLinksOutTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" width="100.0%" height={this.fixHeight != null ? this.fixHeight("100.0%") : "100.0%"} style={{...this.props.style,...display}}>
				<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1667404950" format="bordered" noItemsMessage="No hay elementos con los que se relacione" pageSize={20} itemHeight={50} scrollingMark={false}>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1667404950.a_799515539" style={{width:"40%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1667404950.a_799515539.a317225545" mode="normal" value="Título">
						</UiText>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1667404950.a8808" style={{width:"60%",paddingRight:"10px"}} hidden="Never">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1667404950.a8808.a_1285287854" mode="normal" value="Descripción">
						</UiText>
					</UiHeading>
				</UiTable>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(NodeLinksOutTemplate));
DisplayFactory.register("NodeLinksOutTemplate", withStyles(styles, { withTheme: true })(withSnackbar(NodeLinksOutTemplate)));