import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTable from "alexandria-ui-elements/src/displays/components/Table";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import DisplaysLinksInTableRow from "unit-elements/gen/displays/rows/LinksInTableRow";
import DisplaysLinksInTableLabelItem from "unit-elements/gen/displays/items/LinksInTableLabelItem";
import DisplaysLinksInTableDescriptionItem from "unit-elements/gen/displays/items/LinksInTableDescriptionItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import NodeLinksInTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import NodeLinksInTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class NodeLinksInTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new NodeLinksInTemplateNotifier(this);
		this.requester = new NodeLinksInTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" width="100.0%" height={this.fixHeight != null ? this.fixHeight("100.0%") : "100.0%"} style={{...this.props.style,...display}}>
				<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124382024" format="bordered" noItemsMessage="No hay elementos que lo relacionen" pageSize={20} itemHeight={50} scrollingMark={false}>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124382024.a_1289219689" style={{width:"40%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124382024.a_1289219689.a1974135901" mode="normal" value="Título">
						</UiText>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124382024.a1141824812" style={{width:"60%",paddingRight:"10px"}} hidden="Never">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1124382024.a1141824812.a1460818572" mode="normal" value="Descripción">
						</UiText>
					</UiHeading>
				</UiTable>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(NodeLinksInTemplate));
DisplayFactory.register("NodeLinksInTemplate", withStyles(styles, { withTheme: true })(withSnackbar(NodeLinksInTemplate)));