/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.util;

import java.text.Normalizer;

public class StringHelper {
    public static String validName(String name) {
        if (name == null) {
            return null;
        }
        name = name.replace("/", "-").replace(" ", "-").replace("_", "-");
        return StringHelper.stripAccents(StringHelper.firstLowerCase(StringHelper.snakeCaseToCamelCase(name)));
    }

    public static String stripAccents(String s) {
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        s = s.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return s;
    }

    public static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    public static String firstLowerCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static String camelCaseToSnakeCase(String string) {
        if (string.isEmpty()) {
            return string;
        }
        Object result = String.valueOf(Character.toLowerCase(string.charAt(0)));
        for (int i = 1; i < string.length(); ++i) {
            result = (String)result + String.valueOf(Character.isUpperCase(string.charAt(i)) ? "-" + Character.toLowerCase(string.charAt(i)) : Character.valueOf(string.charAt(i)));
        }
        return result;
    }

    public static String snakeCaseToCamelCase(String string) {
        if (string.isEmpty()) {
            return string;
        }
        Object result = "";
        for (String part : string.replace("_", "-").split("-")) {
            result = (String)result + String.valueOf(Character.toUpperCase(part.charAt(0))) + part.substring(1);
        }
        return result;
    }

    public static String clean(String text) {
        return Normalizer.normalize(text, Normalizer.Form.NFD).replaceAll("[^a-zA-Z]", "");
    }
}

