/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.util;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.Asset;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.Actionable;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.filters.GroupFilter;
import io.intino.alexandria.ui.model.datasource.filters.RangeFilter;
import io.intino.alexandria.ui.server.UIFile;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.FieldSelectDatasource;
import io.intino.goros.unit.box.ui.datasources.model.Column;
import io.intino.goros.unit.printers.SetPrinter;
import io.intino.goros.unit.util.Formatters;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.PathHelper;
import io.intino.goros.unit.util.ResourceHelper;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.minidev.json.JSONObject;
import org.monet.bpi.FieldDate;
import org.monet.bpi.FieldFile;
import org.monet.bpi.FieldLink;
import org.monet.bpi.FieldPicture;
import org.monet.bpi.types.Check;
import org.monet.bpi.types.CheckList;
import org.monet.bpi.types.File;
import org.monet.bpi.types.Link;
import org.monet.bpi.types.Number;
import org.monet.bpi.types.Picture;
import org.monet.bpi.types.Term;
import org.monet.metamodel.AttributeProperty;
import org.monet.metamodel.CheckFieldProperty;
import org.monet.metamodel.ContainerDefinition;
import org.monet.metamodel.Definition;
import org.monet.metamodel.FieldProperty;
import org.monet.metamodel.FormDefinition;
import org.monet.metamodel.FormDefinitionBase;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.IndexDefinitionBase;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.NodeDefinitionBase;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.SelectFieldProperty;
import org.monet.metamodel.SetDefinition;
import org.monet.metamodel.SetDefinitionBase;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.agents.AgentLogger;
import org.monet.space.kernel.agents.AgentNotifier;
import org.monet.space.kernel.agents.AgentUserClient;
import org.monet.space.kernel.components.ComponentDocuments;
import org.monet.space.kernel.components.layers.NodeLayer;
import org.monet.space.kernel.model.Account;
import org.monet.space.kernel.model.Attribute;
import org.monet.space.kernel.model.ClientOperation;
import org.monet.space.kernel.model.DataRequest;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.Entity;
import org.monet.space.kernel.model.Language;
import org.monet.space.kernel.model.MonetEvent;
import org.monet.space.kernel.model.MonetLink;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.NodeDataRequest;
import org.monet.space.kernel.model.NodeItem;
import org.monet.space.kernel.model.OperationConfirmation;
import org.monet.space.kernel.model.Reference;
import org.monet.space.kernel.model.ReferenceAttribute;
import org.monet.space.kernel.model.Revision;
import org.monet.space.kernel.model.Task;
import org.monet.space.kernel.utils.MimeTypes;
import org.monet.space.kernel.utils.StreamHelper;

public class NodeHelper {
    private static final SimpleDateFormat InternalFormat = new SimpleDateFormat("dd/MM/yyyy/HH:mm:ss");
    private static final SimpleDateFormat Format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public static final String OperationShowNode = "shownode";
    public static final String OperationShowNodeView = "shownodeview";
    public static final String OperationShowTask = "showtask";
    public static final String OperationParamId = "Id";
    public static final String OperationParamIdView = "IdView";

    public static Node singleton(String code) {
        return LayerHelper.nodeLayer().locateNode(code);
    }

    public static String nameOf(Node node) {
        return PathHelper.nameOf((Definition)node.getDefinition());
    }

    public static int countItems(Node node, NodeDataRequest request) {
        IndexDefinition index = Dictionary.getInstance().getIndexDefinition(((SetDefinition)node.getDefinition()).getIndex().getValue());
        request.setCodeReference(index.getCode());
        return LayerHelper.nodeLayer().requestNodeListItemsCount(node.getId(), request);
    }

    public static InputStream download(UnitBox box, Node node, NodeDataRequest request, String format, List<String> columns, String language) {
        return new SetPrinter(box, node, request, format, columns).print(language);
    }

    public static boolean isEnvironment(Node node) {
        NodeDefinition definition = node.getDefinition();
        if (definition instanceof ContainerDefinition) {
            return node.getDefinition().isEnvironment();
        }
        return false;
    }

    public static String getEnvironmentNodeId(Account account, String key) {
        Node result = NodeHelper.getEnvironmentNode(account, key);
        return result != null ? result.getId() : null;
    }

    public static Node getEnvironmentNode(Account account, String key) {
        Dictionary dictionary = Dictionary.getInstance();
        NodeDefinition definition = dictionary.getNodeDefinition(key);
        String code = definition.getCode();
        Node result = null;
        if (definition.isDesktop()) {
            result = LayerHelper.nodeLayer().locateNode(code);
        } else if (definition.isEnvironment()) {
            ArrayList environmentNodes = account.getEnvironmentNodes();
            for (Node environmentNode : environmentNodes) {
                if (!environmentNode.getDefinition().getCode().equals(code)) continue;
                return environmentNode;
            }
        }
        return result;
    }

    public static List<Column> downloadColumns(Node node, String view) {
        if (!node.isSet()) {
            return Collections.emptyList();
        }
        SetDefinition.SetViewProperty setViewProperty = (SetDefinition.SetViewProperty)node.getDefinition().getNodeView(view);
        if (setViewProperty.getShow().getIndex() == null) {
            return Collections.emptyList();
        }
        IndexDefinition indexDefinition = Dictionary.getInstance().getIndexDefinition(((SetDefinition)node.getDefinition()).getIndex().getValue());
        SetDefinitionBase.SetViewPropertyBase.ShowProperty showDefinition = setViewProperty.getShow();
        String nameReferenceView = showDefinition.getIndex().getWithView().getValue();
        IndexDefinitionBase.IndexViewProperty referenceViewDefinition = indexDefinition.getView(nameReferenceView);
        return indexDefinition.getAttributes(referenceViewDefinition).stream().map(NodeHelper::columnOf).collect(Collectors.toList());
    }

    private static Column columnOf(AttributeProperty attributeProperty) {
        return new Column().code(attributeProperty.getCode()).label((String)attributeProperty.getLabel()).isDate(attributeProperty.getType() == AttributeProperty.TypeEnumeration.DATE);
    }

    public static ClientOperation clientOperationOf(Revision revision) {
        return NodeHelper.clientOperationOf(revision.getIdNode(), null);
    }

    public static ClientOperation clientOperationOf(Node<?> node) {
        return NodeHelper.clientOperationOf(node.getId(), null);
    }

    public static ClientOperation clientOperationOf(final String node, final String view) {
        HashMap<String, String> data = new HashMap<String, String>(){
            {
                this.put(NodeHelper.OperationParamId, node);
                this.put(NodeHelper.OperationParamIdView, view);
            }
        };
        return new ClientOperation(view != null ? OperationShowNodeView : OperationShowNode, new JSONObject((Map)data));
    }

    public static String internalValueOf(Instant instant) {
        if (instant == null) {
            return null;
        }
        return InternalFormat.format(Date.from(instant));
    }

    public static Node copyNode(Node node, String languageCode) {
        Language language = Language.getInstance();
        NodeLayer nodeLayer = LayerHelper.nodeLayer();
        Node newNode = node.isPrototype() ? nodeLayer.addPrototype(node.getCode(), node.getParent()) : nodeLayer.addNode(node.getCode(), node.getParent());
        String date = Formatters.shortDate(Instant.now());
        String label = node.isPrototype() ? language.getLabel("LBL_CLONE_FROM", languageCode) + " " + node.getLabel() : node.getLabel();
        String description = node.isPrototype() ? node.getDescription() + " " + language.getLabel("LBL_CLONE_AT", languageCode) + " " + date + "." : node.getDescription();
        nodeLayer.copyNode(newNode, node, label, description);
        return newNode;
    }

    public static UIFile downloadOperation(Actionable actionable, Node node, String operation) {
        actionable.readonly(true);
        Node current = LayerHelper.nodeLayer().loadNode(node.getId());
        MonetEvent event = new MonetEvent("nodexecutecommand", null, (Object)current);
        event.addParameter("command", (Object)operation);
        AgentNotifier.getInstance().notify(event);
        final File fileForUser = AgentUserClient.getInstance().getFileForUser(Long.valueOf(Thread.currentThread().getId()));
        actionable.readonly(false);
        return new UIFile(){

            public String label() {
                return fileForUser.getFilename();
            }

            public InputStream content() {
                return fileForUser.getContentAsStream();
            }
        };
    }

    public static boolean isOperationConfirmationRequired(Node node, String operation) {
        OperationConfirmation confirmation = new OperationConfirmation();
        Node current = LayerHelper.nodeLayer().loadNode(node.getId());
        MonetEvent event = new MonetEvent("nodexecutecommandwhen", null, (Object)current);
        event.addParameter("command", (Object)operation);
        event.addParameter("result", (Object)confirmation);
        AgentNotifier.getInstance().notify(event);
        return confirmation.isRequired();
    }

    public static NodeDefinitionBase.OperationProperty operation(Node node, String name) {
        return node.getDefinition().getOperationMap().getOrDefault(name, null);
    }

    public static void executeOperation(UISession session, Actionable<?, ?> actionable, Node<?> node, String operation, String successMessage, DisplayRouteDispatcher dispatcher) {
        NodeHelper.executeOperation(session, actionable, node, operation, successMessage, (ClientOperation clientOperation) -> NodeHelper.dispatchOperation(dispatcher, session, clientOperation));
    }

    public static void executeOperation(UISession session, Actionable actionable, Node node, String operation, String successMessage, Consumer<ClientOperation> dispatcher) {
        actionable.readonly(true);
        Node current = LayerHelper.nodeLayer().loadNode(node.getId());
        MonetEvent event = new MonetEvent("nodexecutecommand", null, (Object)current);
        event.addParameter("command", (Object)operation);
        AgentNotifier.getInstance().notify(event);
        actionable.readonly(false);
        ClientOperation clientOperation = AgentUserClient.getInstance().getOperationForUser(Long.valueOf(Thread.currentThread().getId()));
        String message = NodeHelper.agentUserClientMessage();
        if (dispatcher != null && clientOperation != null) {
            dispatcher.accept(clientOperation);
        }
        if (clientOperation != null) {
            if (message != null) {
                actionable.notifyUser(successMessage, UserMessage.Type.Info);
            }
        } else if (message != null) {
            actionable.notifyUser(message, UserMessage.Type.Error);
        }
    }

    public static void cancelOperation(UISession session, Actionable actionable, Node node, String operation, String successMessage, DisplayRouteDispatcher dispatcher) {
        NodeHelper.cancelOperation(session, actionable, node, operation, successMessage, (ClientOperation clientOperation) -> {});
    }

    public static void cancelOperation(UISession session, Actionable actionable, Node node, String operation, String successMessage, Consumer<ClientOperation> dispatcher) {
        actionable.readonly(true);
        Node current = LayerHelper.nodeLayer().loadNode(node.getId());
        MonetEvent event = new MonetEvent("nodexecutecommandoncancel", null, (Object)current);
        event.addParameter("command", (Object)operation);
        AgentNotifier.getInstance().notify(event);
        actionable.readonly(false);
        String message = NodeHelper.agentUserClientMessage();
        if (message == null) {
            return;
        }
        actionable.notifyUser(successMessage, UserMessage.Type.Info);
    }

    public static String valueOrDefault(FieldDate field) {
        if (field == null || field.get() == null) {
            return "Sin definir";
        }
        return ((org.monet.bpi.types.Date)field.get()).getFormattedValue();
    }

    public static String valueOrDefault(FieldLink field) {
        if (field == null || field.get() == null) {
            return "Sin definir";
        }
        return ((Link)field.get()).getLabel();
    }

    private static String agentUserClientMessage() {
        String message = AgentUserClient.getInstance().getMessageForUser(Long.valueOf(Thread.currentThread().getId()));
        AgentUserClient.getInstance().clear(Long.valueOf(Thread.currentThread().getId()));
        return message;
    }

    public static Entity<?> operationEntity(ClientOperation operation) {
        String name = operation.getName().toLowerCase();
        String id = operation.getData().get((Object)OperationParamId).toString();
        if (OperationShowNode.equals(name) || OperationShowNodeView.equals(name)) {
            return LayerHelper.nodeLayer().loadNode(id);
        }
        if (OperationShowTask.equals(name)) {
            return LayerHelper.taskLayer().loadTask(operation.getData().get((Object)OperationParamId).toString());
        }
        return null;
    }

    public static String operationPath(ClientOperation operation) {
        boolean readonly;
        Entity<?> entity = NodeHelper.operationEntity(operation);
        String name = operation.getName().toLowerCase();
        String mode = operation.getData().get((Object)"Mode") != null ? operation.getData().get((Object)"Mode").toString() : null;
        boolean bl = readonly = mode == null || !mode.contains("edit.html");
        if (OperationShowNode.equals(name)) {
            return PathHelper.pathOf((Node)entity, null, readonly ? "default" : "edit");
        }
        if (OperationShowNodeView.equals(name)) {
            return PathHelper.pathOf((Node)entity, operation.getData().get((Object)OperationParamIdView).toString(), readonly ? "default" : "edit");
        }
        if (OperationShowTask.equals(name)) {
            return PathHelper.pathOf((Task)entity);
        }
        return null;
    }

    public static void dispatchOperation(DisplayRouteDispatcher dispatcher, UISession session, ClientOperation operation) {
        if (operation == null) {
            return;
        }
        Soul soul = ((UIClient)session.client()).soul();
        dispatcher.dispatch(soul, NodeHelper.operationPath(operation));
    }

    public static Task recentTask(Node node, String view) {
        return NodeHelper.recentTask(node, node.getDefinition().getNodeView(view));
    }

    public static Task recentTask(Node node, NodeViewProperty view) {
        ArrayList taskList = new ArrayList(node.getLinkedTasks().get().values());
        if (taskList.size() <= 0) {
            return null;
        }
        List<String> taskTypes = NodeHelper.recentTaskTypes(node, view);
        return taskTypes.size() > 0 ? (Task)taskList.stream().filter(task -> taskTypes.contains(task.getDefinition().getName())).findFirst().orElse(null) : (Task)taskList.get(0);
    }

    public static String valueOf(Node node, String attribute) {
        Attribute attributeObject = node.getAttribute(attribute);
        return attributeObject != null ? attributeObject.getIndicatorValue("value") : null;
    }

    public static String valueOf(NodeItem node, String attribute) {
        return node.getAttribute(attribute);
    }

    public static Double numberOf(Reference reference, String attribute) {
        Object value = reference.getAttribute(attribute).getValue();
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    public static Double numberOf(NodeItem node, String attribute) {
        String value = node.getAttribute(attribute);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Double.valueOf(value);
    }

    public static Node nodeOf(MonetLink link) {
        if (link == null) {
            return null;
        }
        return LayerHelper.nodeLayer().loadNode(link.getId());
    }

    public static Node nodeOf(Link link) {
        if (link == null) {
            return null;
        }
        return LayerHelper.nodeLayer().loadNode(link.getId());
    }

    public static NodeItem nodeItemOf(Link link) {
        if (link == null) {
            return null;
        }
        NodeItem result = new NodeItem();
        result.addAttribute("id_node", link.getId());
        result.addAttribute("label", link.getLabel());
        return result;
    }

    public static List<NodeItem> nodeItemsOf(List<Link> links) {
        return links.stream().map(NodeHelper::nodeItemOf).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static CheckList checkListOf(CheckList checkList, List<String> selection) {
        checkList.getAll().forEach(check -> check.setChecked(selection.contains(check.getLabel())));
        return checkList;
    }

    public static List<String> selectionOf(List<Term> termList, CheckList checkList) {
        return checkList.getAll().stream().filter(Check::isChecked).map(c -> {
            Term term = NodeHelper.termOf(termList, c);
            return term != null ? term.getLabel() : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Term termOf(List<Term> source, Check check) {
        return source.stream().filter(t -> t.getKey().equals(check.getCode())).findFirst().orElse(null);
    }

    public static List<String> selectionOf(CheckList checkList) {
        return checkList.getAll().stream().filter(Check::isChecked).map(Check::getLabel).collect(Collectors.toList());
    }

    public static List<String> selectionOf(List<Term> source, List<Term> terms) {
        return terms.stream().map(t -> {
            Term term = NodeHelper.findTerm(t, source);
            return term != null ? term.getLabel() : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<String> selectionOf(List<Term> terms) {
        return terms.stream().map(Term::getLabel).collect(Collectors.toList());
    }

    public static List<String> selectionOf(List<Term> source, Term term) {
        if (term == null) {
            return Collections.emptyList();
        }
        Term selected = NodeHelper.findTerm(term, source);
        return Collections.singletonList(selected != null ? selected.getLabel() : term.getLabel());
    }

    public static List<String> selectionOf(Term term) {
        return term != null ? Collections.singletonList(term.getLabel()) : Collections.emptyList();
    }

    private static Term findTerm(Term term, List<Term> source) {
        if (term == null) {
            return null;
        }
        return source.stream().filter(t -> t.getKey().equals(term.getKey())).findFirst().orElse(term);
    }

    public static String getContainerContain(Node node, String code) {
        Dictionary dictionary = Dictionary.getInstance();
        ContainerDefinition definition = (ContainerDefinition)node.getDefinition();
        NodeDefinition nodeDefinition = definition.getContain().getNode().stream().map(n -> dictionary.getNodeDefinition(n.getValue())).filter(d -> d.getCode().equals(code)).findFirst().orElse(null);
        if (nodeDefinition == null) {
            return null;
        }
        return NodeHelper.valueOf(node, nodeDefinition.getCode());
    }

    public static String valueOf(Reference reference, String attributeKey) {
        ReferenceAttribute attribute = reference.getAttribute(attributeKey);
        return attribute != null ? attribute.getValueAsString() : null;
    }

    public static Instant instantOf(Node node, String attribute) {
        try {
            String value = node.getAttribute(attribute).getIndicatorValue("internal");
            if (value == null || value.isEmpty()) {
                return null;
            }
            return InternalFormat.parse(value).toInstant();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Instant instantOf(NodeItem node, String attribute) {
        try {
            String value = node.getAttribute(attribute);
            if (value == null || value.isEmpty()) {
                return null;
            }
            return Format.parse(value).toInstant();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Instant instantOf(Reference reference, String attribute) {
        ReferenceAttribute referenceAttribute = reference.getAttribute(attribute);
        if (referenceAttribute == null) {
            return null;
        }
        return NodeHelper.instantOf((org.monet.bpi.types.Date)referenceAttribute.getValue());
    }

    public static Instant instantOf(FieldDate field) {
        return NodeHelper.instantOf((org.monet.bpi.types.Date)field.get());
    }

    public static Instant instantOf(org.monet.bpi.types.Date date) {
        if (date == null) {
            return null;
        }
        return date.getValue().toInstant();
    }

    public static URL urlOf(Reference reference, String attribute, boolean preview) {
        ReferenceAttribute picture = reference.getAttribute(attribute);
        if (picture == null) {
            return null;
        }
        return NodeHelper.urlOf((Picture)picture.getValue(), preview);
    }

    public static URL urlOf(FieldPicture field, boolean preview) {
        return NodeHelper.urlOf((Picture)field.get(), preview);
    }

    public static URL urlOf(FieldPicture field) {
        return NodeHelper.urlOf((Picture)field.get(), false);
    }

    public static URL spaceUrlOf(URL url, URL baseUrl) {
        if (url == null) {
            return null;
        }
        return Asset.toResource((URL)baseUrl, (URL)url).toUrl();
    }

    public static URL urlOf(Picture picture, boolean preview) {
        if (picture == null || picture.getFilename() == null) {
            return null;
        }
        return NodeHelper.urlOf(URLEncoder.encode(picture.getFilename(), StandardCharsets.UTF_8), preview ? "1" : "0");
    }

    public static URL urlOf(Node node) {
        if (node == null) {
            return null;
        }
        return NodeHelper.urlOf(node.getId(), "0");
    }

    public static URL urlOf(String id, String preview) {
        try {
            String downloadUrl;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", id);
            if (preview.equals("1")) {
                params.put("thumb", preview);
            }
            return new URL(downloadUrl + ((downloadUrl = ComponentDocuments.getInstance().getDownloadUrl(params)).contains("?") ? "&" : "?") + "r=" + Math.random());
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public static URL urlOf(FieldFile field) {
        return NodeHelper.urlOf((File)field.get());
    }

    public static String contentTypeOf(FieldFile field) {
        return NodeHelper.contentTypeOf((File)field.get());
    }

    public static String contentTypeOf(FieldPicture field) {
        return NodeHelper.contentTypeOf((File)field.get());
    }

    public static String contentTypeOf(Node node) {
        if (node == null) {
            return null;
        }
        return NodeHelper.contentTypeOf(node.getId());
    }

    public static URL urlOf(File file) {
        try {
            if (file == null || file.getFilename() == null) {
                return null;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", URLEncoder.encode(file.getFilename(), StandardCharsets.UTF_8));
            return new URL(ComponentDocuments.getInstance().getDownloadUrl(params));
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public static String contentTypeOf(File file) {
        if (file == null || file.getFilename() == null) {
            return null;
        }
        return NodeHelper.contentTypeOf(file.getFilename());
    }

    public static String contentTypeOf(String id) {
        try {
            return ComponentDocuments.getInstance().getDocumentContentType(id);
        }
        catch (Throwable ex) {
            Logger.error((Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Picture pictureOf(Resource value, int width, int height) {
        if (value == null) {
            return null;
        }
        InputStream sourceStream = null;
        String name = NodeHelper.withStamp(value.name());
        try {
            sourceStream = value.stream();
            String contentType = value.metadata().contentType();
            BufferedImage image = NodeHelper.imageOf(sourceStream);
            ComponentDocuments.getInstance().uploadImage(name, image == null || NodeHelper.isSmaller(image, width, height) ? NodeHelper.streamOf(image, value.metadata().contentType()) : NodeHelper.reduce(image, value.metadata().contentType(), width, height), contentType, width, height);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        finally {
            if (sourceStream != null) {
                StreamHelper.close((InputStream)sourceStream);
            }
        }
        return new Picture(name);
    }

    public static Picture pictureOf(Resource value) {
        if (value == null) {
            return null;
        }
        String name = NodeHelper.withStamp(value.name());
        return Picture.fromInputStream((String)name, (String)value.metadata().contentType(), (InputStream)ResourceHelper.streamOf(value));
    }

    public static Link linkOf(Node node, String attribute) {
        Attribute attributeObject = node.getAttribute(attribute);
        return attributeObject != null ? NodeHelper.linkOf(attributeObject.getIndicatorValue("nodelink"), attributeObject.getIndicatorValue("value")) : null;
    }

    public static List<Link> linksOf(List<NodeItem> links) {
        return links.stream().map(NodeHelper::linkOf).collect(Collectors.toList());
    }

    public static Link linkOf(List<NodeItem> selection) {
        return selection.size() > 0 ? NodeHelper.linkOf(selection.get(0)) : null;
    }

    public static Link linkOf(NodeItem node) {
        return NodeHelper.linkOf(node.getAttribute("id_node"), node.getAttribute("label"));
    }

    public static Link linkOf(Node node) {
        return NodeHelper.linkOf(node.getId(), node.getLabel());
    }

    public static Link linkOf(String id, String label) {
        Link result = new Link();
        result.setId(id);
        result.setLabel(label);
        return result;
    }

    public static List<Term> termsOf(FieldSelectDatasource source, List<String> selection) {
        return selection.stream().map(source::item).collect(Collectors.toList());
    }

    public static Term termOf(FieldSelectDatasource source, List<String> selection) {
        return selection.size() > 0 ? source.item(selection.get(0)) : null;
    }

    public static org.monet.bpi.types.Date dateOf(Instant value) {
        return value != null ? new org.monet.bpi.types.Date(Date.from(value)) : null;
    }

    public static File fileOf(Resource resource) {
        try {
            return resource != null ? File.fromInputStream((String)NodeHelper.withStamp(resource.name()), (String)resource.metadata().contentType(), (InputStream)resource.stream()) : null;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public static io.intino.alexandria.ui.File alexandriaFileOf(FieldFile file) {
        return NodeHelper.alexandriaFileOf((File)file.get());
    }

    public static io.intino.alexandria.ui.File alexandriaFileOf(FieldPicture file) {
        return NodeHelper.alexandriaFileOf((File)file.get());
    }

    public static io.intino.alexandria.ui.File alexandriaFileOf(File file) {
        if (file == null) {
            return null;
        }
        Object filename = file.getFilename();
        if (!((String)filename).contains(".")) {
            filename = (String)filename + "." + MimeTypes.getInstance().getExtension(NodeHelper.contentTypeOf(file));
        }
        return new io.intino.alexandria.ui.File().value(NodeHelper.urlOf(file)).mimeType(NodeHelper.contentTypeOf(file)).filename((String)filename);
    }

    public static String linkIdOf(FieldLink field) {
        Link link = (Link)field.get();
        return link != null ? link.getId() : null;
    }

    public static String canRemove(Node node) {
        if (node.isSingleton()) {
            return "No se puede eliminar. El elemento est\u00e1 marcado como singleton.";
        }
        if (node.isLinked()) {
            return "No se puede eliminar. El elemento tiene relaciones con otros elementos.";
        }
        return null;
    }

    public static String filtersMessage(Node node, List<Filter> filters) {
        IndexDefinition definition = Dictionary.getInstance().getIndexDefinition(((SetDefinition)node.getDefinition()).getIndex().getValue());
        return filters.stream().map(f -> NodeHelper.filterMessage(definition, f)).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    private static String filterMessage(IndexDefinition definition, Filter filter) {
        if (filter instanceof GroupFilter) {
            return NodeHelper.groupFilterMessage(definition, filter);
        }
        if (filter instanceof RangeFilter) {
            return NodeHelper.rangeFilterMessage(definition, filter);
        }
        return null;
    }

    private static String groupFilterMessage(IndexDefinition definition, Filter f) {
        GroupFilter filter = (GroupFilter)f;
        if (filter.groups().isEmpty()) {
            return "";
        }
        AttributeProperty attributeDefinition = definition.getAttribute(filter.grouping());
        if (attributeDefinition == null) {
            return "";
        }
        return String.valueOf(attributeDefinition.getLabel()) + "(" + String.join((CharSequence)", ", filter.groups()) + ")";
    }

    private static String rangeFilterMessage(IndexDefinition definition, Filter f) {
        AttributeProperty attributeDefinition = definition.getAttribute(f.grouping());
        if (attributeDefinition == null) {
            return "";
        }
        RangeFilter rangeFilter = (RangeFilter)f;
        if (rangeFilter.from() == null || rangeFilter.to() == null) {
            return null;
        }
        String from = Formatters.shortDate(rangeFilter.from());
        String to = Formatters.shortDate(rangeFilter.to());
        return String.valueOf(attributeDefinition.getLabel()) + "(" + from + " - " + to + ")";
    }

    public static Set<String> getFieldFilters(Node node, FieldProperty fieldDefinition, boolean mask) {
        CheckFieldProperty.SelectProperty selectDefinition;
        LinkedHashSet<String> filtersSet = new LinkedHashSet<String>();
        ArrayList tagList = null;
        if (fieldDefinition.isCheck()) {
            selectDefinition = ((CheckFieldProperty)fieldDefinition).getSelect();
            if (selectDefinition != null && selectDefinition.getFilter() != null) {
                tagList = selectDefinition.getFilter().getTag();
            }
        } else if (fieldDefinition.isSelect() && (selectDefinition = ((SelectFieldProperty)fieldDefinition).getSelect()) != null && selectDefinition.getFilter() != null) {
            tagList = selectDefinition.getFilter().getTag();
        }
        if (tagList == null) {
            return filtersSet;
        }
        for (Object tag : tagList) {
            String filterValue = "";
            if (tag instanceof String) {
                filterValue = (String)tag;
            } else if (tag instanceof Ref) {
                String fieldName = ((Ref)tag).getValue();
                String string = filterValue = mask ? "_field:" + ((FormDefinition)node.getDefinition()).getField(fieldName).getCode() : node.getFieldValue(fieldName);
            }
            if (filterValue.isEmpty()) continue;
            filtersSet.add(filterValue);
        }
        return filtersSet;
    }

    public static List<DataRequest.GroupBy> groupsByOf(List<Filter> filters) {
        if (filters == null) {
            return Collections.emptyList();
        }
        return filters.stream().map(NodeHelper::groupByOf).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<DataRequest.GroupBy> groupByOf(Filter filter) {
        if (filter == null) {
            return Collections.emptyList();
        }
        if (filter instanceof GroupFilter) {
            return Collections.singletonList(NodeHelper.groupByOf(filter.grouping(), ((GroupFilter)filter).groups()));
        }
        if (filter instanceof RangeFilter) {
            return Arrays.asList(NodeHelper.groupByOf(filter.grouping(), ((RangeFilter)filter).from(), DataRequest.GroupBy.Operator.Gt), NodeHelper.groupByOf(filter.grouping(), ((RangeFilter)filter).to(), DataRequest.GroupBy.Operator.Lt));
        }
        return Collections.emptyList();
    }

    public static List<DataRequest.SortBy> sortsByOf(List<String> sortings) {
        if (sortings == null) {
            return Collections.emptyList();
        }
        return sortings.stream().map(NodeHelper::sortByOf).collect(Collectors.toList());
    }

    public static String sortingOf(String attribute, String mode) {
        return attribute + "#" + (mode.toLowerCase().startsWith("asc") ? "ASC" : "DESC");
    }

    private static DataRequest.SortBy sortByOf(String sorting) {
        final String[] split = sorting.split("#");
        return new DataRequest.SortBy(){

            public String attribute() {
                return split[0];
            }

            public String mode() {
                return split.length > 1 ? split[1] : "ASC";
            }
        };
    }

    private static DataRequest.GroupBy groupByOf(final String grouping, final Set<String> groups) {
        return new DataRequest.GroupBy(){

            public String attribute() {
                return grouping;
            }

            public List<Object> values() {
                return new ArrayList<Object>(groups);
            }

            public <T> T value(int i) {
                return null;
            }

            public DataRequest.GroupBy.Operator operator() {
                return DataRequest.GroupBy.Operator.Eq;
            }
        };
    }

    private static DataRequest.GroupBy groupByOf(final String grouping, final Instant instant, final DataRequest.GroupBy.Operator operator) {
        if (instant == null) {
            return null;
        }
        return new DataRequest.GroupBy(){

            public String attribute() {
                return grouping;
            }

            public List<Object> values() {
                return Collections.singletonList(Date.from(instant));
            }

            public <T> T value(int i) {
                return null;
            }

            public DataRequest.GroupBy.Operator operator() {
                return operator;
            }
        };
    }

    private static List<String> recentTaskTypes(Node node, NodeViewProperty view) {
        ArrayList<String> taskTypes = new ArrayList<String>();
        if (view instanceof FormDefinitionBase.FormViewProperty) {
            FormDefinitionBase.FormViewProperty.ShowProperty showDefinition = ((FormDefinitionBase.FormViewProperty)view).getShow();
            for (Ref ref : showDefinition.getRecentTask().getTask()) {
                taskTypes.add(ref.getValue());
            }
        }
        return taskTypes;
    }

    private static BufferedImage imageOf(InputStream imageStream) {
        try {
            byte[] imageBytes = StreamHelper.readBytes((InputStream)imageStream);
            return ImageIO.read(new ByteArrayInputStream(imageBytes));
        }
        catch (IOException e) {
            AgentLogger.getInstance().error((Throwable)e);
            return null;
        }
    }

    private static InputStream streamOf(BufferedImage image, String contentType) throws IOException {
        ByteArrayOutputStream imageTempOutput = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, MimeTypes.getInstance().getExtension(contentType), imageTempOutput);
        return new ByteArrayInputStream(imageTempOutput.toByteArray());
    }

    private static boolean isSmaller(BufferedImage image, int width, int height) {
        return image.getWidth() <= width && image.getHeight() <= height;
    }

    private static InputStream reduce(BufferedImage image, String contentType, int width, int height) throws IOException {
        boolean alpha = NodeHelper.hasAlpha(image, contentType);
        BufferedImage bdest = new BufferedImage(width, height, alpha ? 2 : 1);
        Graphics2D g = bdest.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        Transform transform = NodeHelper.getScaleFactor(image.getWidth(), image.getHeight(), width, height);
        if (transform == null) {
            g.drawImage((Image)image, 0, 0, null);
        } else if (transform.type == Transform.Type.SCALE) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(transform.width, transform.height);
            g.translate(((double)width - (double)image.getWidth() * transform.width) / 2.0, 0.0);
            g.drawRenderedImage(image, affineTransform);
        } else if (transform.type == Transform.Type.TRANSLATE) {
            g.drawImage((Image)image, Double.valueOf(transform.width).intValue(), Double.valueOf(transform.height).intValue(), null);
        }
        g.dispose();
        return NodeHelper.streamOf(bdest, contentType);
    }

    private static boolean hasAlpha(Image image, String contentType) {
        boolean alpha;
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        String extension = MimeTypes.getInstance().getExtension(contentType);
        if (extension.equalsIgnoreCase("jpeg") || extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpe")) {
            return false;
        }
        try {
            pg.grabPixels();
            alpha = pg.getColorModel().hasAlpha();
        }
        catch (InterruptedException e) {
            alpha = false;
        }
        return alpha;
    }

    private static Transform getScaleFactor(int width, int height, int boundaryWidth, int boundaryHeight) {
        Dimension scaledDimension = NodeHelper.getScaledDimension(width, height, boundaryWidth, boundaryHeight);
        return new Transform(Transform.Type.SCALE, (double)scaledDimension.width / (double)width, (double)scaledDimension.height / (double)height);
    }

    public static Dimension getScaledDimension(int width, int height, int boundaryWidth, int boundaryHeight) {
        int new_width = width;
        int new_height = height;
        if (width > boundaryWidth) {
            new_width = boundaryWidth;
            new_height = new_width * height / width;
        }
        if (new_height > boundaryHeight) {
            new_height = boundaryHeight;
            new_width = new_height * width / height;
        }
        return new Dimension(new_width, new_height);
    }

    private static String withStamp(String name) {
        return NodeHelper.stamp() + "-" + name;
    }

    private static String stamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    private static class Transform {
        Type type;
        double width;
        double height;

        public Transform(Type type, double width, double height) {
            this.type = type;
            this.width = width;
            this.height = height;
        }

        static enum Type {
            SCALE,
            TRANSLATE;

        }
    }
}

