/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;
import io.intino.alexandria.ui.displays.events.collection.RefreshCountEvent;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTrashTemplate;
import io.intino.goros.unit.util.Formatters;
import io.intino.goros.unit.util.LayerHelper;

public class TrashTemplate
extends AbstractTrashTemplate<UnitBox> {
    public TrashTemplate(UnitBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.initToolbars();
        this.initViews();
    }

    public void refresh() {
        super.refresh();
        this.refreshView();
        this.refreshFilters();
    }

    private void initToolbars() {
        this.toolbar.onEmptyTrash(e -> this.emptyTrash());
        this.search.bindTo(new Collection[]{this.tableView.tableViewStamp.trashTable});
    }

    private void initViews() {
        this.filtersView.onInit(e -> this.filtersView.tableFilters.tableFiltersStamp.bindTo((Collection)this.tableView.tableViewStamp.trashTable));
        this.tableView.tableViewStamp.trashTable.onRefreshItemCount(this::refreshCount);
        this.tableView.onShow(e -> {
            this.search.bindTo(new Collection[]{this.tableView.tableViewStamp.trashTable});
            this.tableView.tableViewStamp.refresh();
            this.showFilters();
        });
    }

    private void refreshView() {
        this.tableView.tableViewStamp.refresh();
    }

    private void refreshFilters() {
    }

    private void toggleFiltersViewVisibility(ToggleEvent.State state) {
        if (state == ToggleEvent.State.On) {
            this.filtersView.show();
        } else {
            this.filtersView.hide();
        }
    }

    private void showFilters() {
        if (!this.filtersView.isVisible()) {
            return;
        }
        this.filtersView.tableFilters.hide();
    }

    private void refreshCount(RefreshCountEvent event) {
        String label = this.translate("Element").toLowerCase();
        this.count.value(Formatters.countMessage(event.count(), label, label + " " + this.translate("deleted")));
    }

    private void emptyTrash() {
        LayerHelper.nodeLayer().emptyTrash();
        this.tableView.tableViewStamp.refresh();
    }
}

