/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.model.role.RoleTypeGrouping;
import io.intino.goros.unit.box.ui.displays.templates.AbstractRoleEmbeddedTemplate;
import io.intino.goros.unit.util.Formatters;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.RoleHelper;
import java.sql.Date;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Consumer;
import org.monet.space.kernel.model.Role;

public class RoleEmbeddedTemplate
extends AbstractRoleEmbeddedTemplate<UnitBox> {
    private Role role;
    private boolean readonly = true;
    private Consumer<Role> finishEditionListener;

    public RoleEmbeddedTemplate(UnitBox box) {
        super(box);
    }

    public RoleEmbeddedTemplate role(Role role) {
        this.role = role;
        return this;
    }

    public RoleEmbeddedTemplate readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public RoleEmbeddedTemplate onChange(Consumer<Role> listener) {
        this.finishEditionListener = listener;
        return this;
    }

    public void bindTo(Collection collection) {
        this.previous.bindTo(collection);
        this.previous.visible(collection != null);
        this.next.bindTo(collection);
        this.next.visible(collection != null);
    }

    @Override
    public void init() {
        super.init();
        this.edit.onExecute(e -> this.toggleEdition());
        this.revoke.onExecute(e -> this.revoke());
        this.endDate.onChange(e -> this.save((Instant)e.value()));
    }

    public void refresh() {
        super.refresh();
        this.edit.title(this.translate(this.readonly ? "Edit" : "Finish edition"));
        this.user.value(RoleHelper.userOf(this.role));
        this.message.value(this.message());
        this.state.value(this.translate(RoleHelper.stateLabel(this.role)));
        this.state.backgroundColor(this.translate(RoleHelper.stateColor(this.role)));
        this.definition.value(RoleHelper.definitionLabelOf(this.role));
        this.type.value(RoleTypeGrouping.from(this.role.getType().name()).title());
        this.nature.value(RoleHelper.natureOf(this.role));
        this.startDate.value(this.role.getInternalBeginDate().toInstant());
        this.endDate.value(this.role.getInternalExpireDate() != null ? this.role.getInternalExpireDate().toInstant() : null);
        this.endDate.readonly(this.readonly);
        this.revoke.visible(this.readonly);
        this.revoke.readonly(RoleHelper.isExpired(this.role));
    }

    private String message() {
        String message = RoleHelper.isExpired(this.role) ? "Role is expired since ::endDate::" : (this.role.getInternalExpireDate() == null ? "Role is active since ::startDate:: and no expires" : "Role is active since ::startDate:: and expires at ::endDate::");
        message = this.translate(message);
        message = message.replaceAll("::startDate::", Formatters.shortDate(this.role.getInternalBeginDate().toInstant()));
        if (this.role.getInternalExpireDate() != null) {
            message = message.replaceAll("::endDate::", Formatters.shortDate(this.role.getInternalExpireDate().toInstant()));
        }
        return message;
    }

    private void revoke() {
        Instant startDate = Instant.ofEpochMilli(this.role.getInternalBeginDate().toInstant().toEpochMilli());
        startDate = startDate.minus(1L, ChronoUnit.DAYS);
        this.role.setExpireDate(Date.from(startDate));
        LayerHelper.roleLayer().saveRole(this.role);
        this.finishEditionListener.accept(this.role);
        this.refresh();
    }

    private void save(Instant endDate) {
        this.role.setExpireDate(endDate != null ? Date.from(endDate) : null);
        LayerHelper.roleLayer().saveRole(this.role);
        if (this.finishEditionListener != null) {
            this.finishEditionListener.accept(this.role);
        }
        this.refresh();
    }

    private void toggleEdition() {
        this.readonly(!this.readonly);
        this.refresh();
    }
}

