/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.server.UIFile;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.model.Column;
import io.intino.goros.unit.box.ui.displays.templates.AbstractNodeDownloadDialog;
import io.intino.goros.unit.box.ui.displays.templates.DownloadDialogOption;
import io.intino.goros.unit.util.Formatters;
import io.intino.goros.unit.util.NodeHelper;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.NodeDataRequest;

public class NodeDownloadDialog
extends AbstractNodeDownloadDialog<UnitBox> {
    private Node node;
    private String view;
    private List<Column> columns = new ArrayList<Column>();
    private Consumer<Boolean> terminateListener;
    private String condition;
    private List<Filter> filters;
    private String sorting;
    private String sortingMode;

    public NodeDownloadDialog(UnitBox box) {
        super(box);
    }

    public NodeDownloadDialog onTerminate(Consumer<Boolean> listener) {
        this.terminateListener = listener;
        return this;
    }

    public NodeDownloadDialog node(Node node) {
        this.node = node;
        return this;
    }

    public NodeDownloadDialog view(String view) {
        this.view = view;
        return this;
    }

    public NodeDownloadDialog condition(String condition) {
        this.condition = condition;
        return this;
    }

    public NodeDownloadDialog filters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    public NodeDownloadDialog sorting(String sorting, String mode) {
        this.sorting = sorting;
        this.sortingMode = mode;
        return this;
    }

    public NodeDownloadDialog columns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.format.onSelect(e -> {
            this.refreshDownloadMessage();
            this.refreshToolbar();
        });
        this.downloadCancel.onExecute(e -> this.terminateListener.accept(true));
        this.downloadAccept.onExecute(e -> this.accept());
        this.columnModeSelector.onSelect(e -> this.updateMode());
    }

    public void refresh() {
        super.refresh();
        this.format.select(new String[]{"pdf"});
        this.columnModeSelector.select("allColumns");
        this.refreshDownloadMessage();
        this.refreshColumns();
        this.refreshToolbar();
    }

    private void refreshDownloadMessage() {
        boolean checkCount;
        boolean bl = checkCount = this.format.selection().isEmpty() || !((String)this.format.selection().get(0)).equalsIgnoreCase("csv");
        if (!checkCount) {
            this.downloadMessage.visible(false);
            return;
        }
        long countItems = this.totalItems(this.request());
        boolean exceeded = this.limitExceeded(countItems);
        this.downloadMessage.visible(exceeded);
        if (!exceeded) {
            return;
        }
        this.downloadMessage.value(String.format("La descarga total es de %s. Por rendimiento, se incluir\u00e1n %s para los formatos PDF \u00f3 XLS. Si desea descargar todos los elementos, seleccione la descarga en formato CSV.", Formatters.countMessage(countItems, "elemento", "elementos"), Formatters.countMessage(this.limit(), "elemento", "elementos")));
    }

    private boolean check() {
        if (this.format.selection().size() <= 0) {
            return false;
        }
        if (this.allColumnsMode()) {
            return true;
        }
        return this.options.children(DownloadDialogOption.class).stream().anyMatch(c -> c.selectedColumn() != null);
    }

    private int totalItems(NodeDataRequest request) {
        return NodeHelper.countItems(this.node, request);
    }

    private boolean limitExceeded(long countItems) {
        boolean check;
        long limit = this.limit();
        boolean bl = check = this.format.selection().isEmpty() || !((String)this.format.selection().get(0)).equals("csv");
        if (!check) {
            return false;
        }
        return limit != -1L && countItems >= limit;
    }

    private int limit() {
        String limit = ((UnitBox)this.box()).configuration().downloadNodesLimit();
        return limit != null && !limit.isEmpty() ? Integer.parseInt(((UnitBox)this.box()).configuration().downloadNodesLimit()) : -1;
    }

    private UIFile accept() {
        this.terminateListener.accept(true);
        this.notifyUser(this.translate("Downloading data..."), UserMessage.Type.Info);
        final String format = (String)this.format.selection().get(0);
        List<String> selection = this.selectedColumns();
        final InputStream result = NodeHelper.download((UnitBox)this.box(), this.node, this.request(), format, selection, this.language());
        this.notifyUser(this.translate("Download finished"), UserMessage.Type.Success);
        return new UIFile(){

            public String label() {
                return NodeDownloadDialog.this.node.getLabel() + "_" + Formatters.downloadDate(Instant.now()) + "." + format.toLowerCase();
            }

            public InputStream content() {
                return result;
            }
        };
    }

    private NodeDataRequest request() {
        NodeDataRequest dataRequest = new NodeDataRequest();
        dataRequest.setCodeDomainNode(this.node.getDefinition().getCode());
        dataRequest.setCodeView(this.view);
        dataRequest.setCondition(this.condition);
        dataRequest.setGroupsBy(NodeHelper.groupsByOf(this.filters));
        if (this.sorting != null) {
            dataRequest.setSortsBy(NodeHelper.sortsByOf(Collections.singletonList(NodeHelper.sortingOf(this.sorting, this.sortingMode))));
        }
        dataRequest.setStartPos(Integer.valueOf(0));
        int countItems = this.totalItems(dataRequest);
        dataRequest.setLimit(Integer.valueOf(this.limitExceeded(countItems) ? this.limit() : countItems));
        return dataRequest;
    }

    private List<String> selectedColumns() {
        if (this.allColumnsMode()) {
            return this.columns.stream().map(Column::code).collect(Collectors.toList());
        }
        List children = this.options.children(DownloadDialogOption.class);
        return children.stream().map(DownloadDialogOption::selectedColumn).filter(Objects::nonNull).map(Column::code).collect(Collectors.toList());
    }

    private List<Column> availableColumns(Column current) {
        List<String> selection = this.selectedColumns();
        return this.columns.stream().filter(c -> current != null && current.code().equals(c.code()) || !selection.contains(c.code())).collect(Collectors.toList());
    }

    private void refreshAvailableColumns() {
        List children = this.options.children(DownloadDialogOption.class);
        children.forEach(c -> c.columns(this.availableColumns(c.selectedColumn())).refresh());
    }

    private void refreshColumns() {
        this.customColumnsBlock.visible(!this.allColumnsMode());
        this.columnsBlock.hide();
        this.options.clear();
        for (int i = 0; i < this.columns.size(); ++i) {
            this.fill(i, (DownloadDialogOption)this.options.add());
        }
        this.columnsBlock.show();
    }

    private void fill(int pos, DownloadDialogOption view) {
        view.index(pos);
        view.columns(this.columns);
        view.onSelect(e -> {
            this.refreshToolbar();
            this.refreshAvailableColumns();
        });
        view.refresh();
    }

    private void refreshToolbar() {
        this.downloadAccept.readonly(!this.check());
    }

    private boolean allColumnsMode() {
        String mode = this.columnModeSelector.selection().size() > 0 ? (String)this.columnModeSelector.selection().get(0) : null;
        return mode == null || mode.equalsIgnoreCase("allColumns");
    }

    private void updateMode() {
        this.customColumnsBlock.visible(!this.allColumnsMode());
        this.refreshToolbar();
    }
}

