/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import io.intino.alexandria.ui.model.PlaceMark;
import io.intino.alexandria.ui.model.datasource.BoundingBox;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.MapDatasource;
import io.intino.alexandria.ui.model.locations.Point;
import io.intino.alexandria.ui.model.locations.Polygon;
import io.intino.alexandria.ui.model.locations.Polyline;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.SetDefinition;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.NodeDataRequest;
import org.monet.space.kernel.model.map.GeometryHelper;
import org.monet.space.kernel.model.map.Location;

public class CollectionMapDatasource
extends MapDatasource<String> {
    private final UnitBox box;
    private final UISession session;
    private Node set;
    private NodeViewProperty view;

    public CollectionMapDatasource(UnitBox box, UISession session, Node set, String view) {
        this.box = box;
        this.session = session;
        this.set = set;
        this.view = set.getDefinition().getNodeView(view);
    }

    public void node(Node node) {
        this.set = node;
    }

    public void view(String view) {
        this.view = this.set.getDefinition().getNodeView(view);
    }

    public List<PlaceMark<String>> placeMarks(String condition, List<Filter> filters, BoundingBox boundingBox) {
        this.box.linkSession(this.session);
        SetDefinition definition = (SetDefinition)this.set.getDefinition();
        IndexDefinition indexDefinition = Dictionary.getInstance().getIndexDefinition(definition.getIndex().getValue());
        HashMap cache = new HashMap();
        return LayerHelper.nodeLayer().loadLocationsInNode(this.set, this.boundingBoxOf(boundingBox), indexDefinition.getCode()).get().values().stream().map(l -> this.fix(CollectionMapDatasource.placeMarkOf(l), cache)).collect(Collectors.toList());
    }

    public long placeMarkCount(String condition, List<Filter> filters) {
        this.box.linkSession(this.session);
        return LayerHelper.nodeLayer().requestNodeListItemsCount(this.set.getId(), this.request(condition, filters));
    }

    public List<Group> groups(String key) {
        List groups = this.set.getGroupOptions(key, Collections.emptyList(), Collections.emptyList());
        return groups.stream().map(o -> new Group().label(o)).collect(Collectors.toList());
    }

    public static PlaceMark<String> placeMarkOf(Node node) {
        String location = CollectionMapDatasource.locationOf(node);
        PlaceMark placeMark = PlaceMark.build((String)node.getLabel(), (String)location);
        placeMark.item((Object)node.getId());
        return placeMark;
    }

    public static PlaceMark<String> placeMarkOf(Location location) {
        PlaceMark placeMark = PlaceMark.build((String)location.getLabel(), (String)CollectionMapDatasource.wktOf(location));
        placeMark.item((Object)location.getNodeId());
        return placeMark;
    }

    private static String locationOf(Node node) {
        return CollectionMapDatasource.wktOf(node.getLocation());
    }

    private static String wktOf(Location location) {
        return location != null ? location.getGeometry().toText() : null;
    }

    private static Node nodeOf(Location location) {
        return LayerHelper.nodeLayer().loadNode(location.getNodeId());
    }

    public static long itemCount(Node set) {
        return LayerHelper.nodeLayer().requestNodeListItemsCount(set.getId(), CollectionMapDatasource.request(set));
    }

    private NodeDataRequest request(String condition, List<Filter> filters) {
        NodeDataRequest request = CollectionMapDatasource.request(this.set);
        request.setCondition(condition);
        request.setGroupsBy(NodeHelper.groupsByOf(filters));
        request.setCodeView(this.view.getCode());
        return request;
    }

    private static NodeDataRequest request(Node set) {
        NodeDataRequest request = new NodeDataRequest();
        request.setCodeReference(((SetDefinition)set.getDefinition()).getIndex().getValue());
        return request;
    }

    private com.vividsolutions.jts.geom.Polygon boundingBoxOf(BoundingBox boundingBox) {
        if (boundingBox == null) {
            return null;
        }
        double dnex = boundingBox.northEast().longitude();
        double dney = boundingBox.northEast().latitude();
        double dswx = boundingBox.southWest().longitude();
        double dswy = boundingBox.southWest().latitude();
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(dswx, dney), new Coordinate(dnex, dney), new Coordinate(dnex, dswy), new Coordinate(dswx, dswy), new Coordinate(dswx, dney)};
        CoordinateArraySequence sequence = new CoordinateArraySequence(coordinates);
        return new com.vividsolutions.jts.geom.Polygon(new LinearRing((CoordinateSequence)sequence, GeometryHelper.getFactory()), null, GeometryHelper.getFactory());
    }

    private PlaceMark<String> fix(PlaceMark<String> placeMark, Map<String, Integer> locations) {
        String wkt;
        if (placeMark.location() == null) {
            return placeMark;
        }
        locations.put(wkt, locations.containsKey(wkt = placeMark.location().toWkt()) ? locations.get(wkt) + 1 : 1);
        if (locations.get(wkt) == 1) {
            return placeMark;
        }
        double offset = (double)locations.get(wkt).intValue() * 2.0E-5;
        this.fixPoint(placeMark, offset);
        this.fixPolyline(placeMark, offset);
        this.fixPolygon(placeMark, offset);
        return placeMark;
    }

    private void fixPoint(PlaceMark<String> placeMark, double offset) {
        if (!placeMark.location().isPoint()) {
            return;
        }
        Point location = (Point)placeMark.location();
        location.longitude(location.longitude() + offset);
        location.latitude(location.latitude() + offset);
    }

    private void fixPolyline(PlaceMark<String> placeMark, double offset) {
        if (!placeMark.location().isPolyline()) {
            return;
        }
        Polyline location = (Polyline)placeMark.location();
        List path = location.path();
        if (path.isEmpty()) {
            return;
        }
        ((Point)path.get(0)).longitude(((Point)path.get(0)).longitude() + offset);
        ((Point)path.get(0)).latitude(((Point)path.get(0)).latitude() + offset);
    }

    private void fixPolygon(PlaceMark<String> placeMark, double offset) {
        if (!placeMark.location().isPolygon()) {
            return;
        }
        Polygon location = (Polygon)placeMark.location();
        List path = location.paths();
        if (path.isEmpty()) {
            return;
        }
        List points = (List)path.get(0);
        if (points.isEmpty()) {
            return;
        }
        ((Point)points.get(0)).longitude(((Point)points.get(0)).longitude() + offset);
        ((Point)points.get(0)).latitude(((Point)points.get(0)).latitude() + offset);
    }
}

