/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.goros.unit.box.actions.Action;
import io.intino.goros.unit.box.services.Request;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.monet.mobile.service.ErrorResult;
import org.monet.mobile.service.Response;
import org.monet.space.kernel.agents.AgentSession;
import org.monet.space.kernel.model.Context;
import org.monet.space.kernel.model.Session;
import org.monet.space.kernel.utils.PersisterHelper;

public class MobileAction
extends Action {
    MobileAction() {
        this.response = new io.intino.goros.unit.box.services.Response(this.context);
    }

    @Override
    protected org.monet.http.Request request(Map<String, Object> parameters) {
        this.initialize();
        return new Request(this.context, parameters);
    }

    protected void initialize() {
        String idSession = this.createSession();
        Context _context = Context.getInstance();
        Long idThread = Thread.currentThread().getId();
        _context.setApplication(idThread, (String)this.context.get((Object)"realIp"), "mobile", "user");
        URL url = null;
        try {
            url = new URL((String)this.context.get((Object)"requestUrl"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        _context.setUserServerConfig(idThread, url.getHost(), url.getPath(), Integer.valueOf(url.getPort()));
        _context.setSessionId(idThread, idSession);
        _context.setDatabaseConnectionType(idThread, "auto");
        this.response = new io.intino.goros.unit.box.services.Response(this.context);
    }

    protected void writeInResponse(ErrorResult error) {
        try {
            this.response.setContext(this.context);
            this.response.setContentType("text/xml");
            this.response.setFilename("out.txt");
            OutputStream outputStream = this.response.getOutputStream();
            StringWriter writer = new StringWriter();
            PersisterHelper.save((Writer)writer, (Object)new Response(error));
            outputStream.write(writer.toString().getBytes(StandardCharsets.UTF_8));
            outputStream.close();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    private String createSession() {
        String idSession;
        AgentSession agentSession = AgentSession.getInstance();
        Session session = agentSession.get(idSession = UUID.randomUUID().toString());
        if (session == null) {
            agentSession.add(idSession);
        }
        return idSession;
    }
}

