/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.actions;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.http.server.AlexandriaHttpContext;
import io.intino.goros.unit.box.UnitBox;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.monet.space.kernel.components.ComponentDocuments;
import org.monet.space.kernel.exceptions.SystemException;
import org.monet.space.kernel.library.LibraryFile;

public class GetImagesAction {
    public UnitBox box;
    public AlexandriaHttpContext context;
    public String path;
    public String id;

    public Resource execute() throws BadRequest {
        InputStream input;
        Integer iStatus;
        HttpClient oHttpClient = new HttpClient();
        String requestUrl = this.context.requestUrl();
        try {
            requestUrl = URLDecoder.decode(this.context.requestUrl(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String service = "/image/" + this.id + "/";
        this.path = requestUrl.substring(requestUrl.indexOf(service) + service.length(), requestUrl.length());
        if (this.id == null) {
            throw new BadRequest("Id not found");
        }
        ComponentDocuments componentDocuments = ComponentDocuments.getInstance();
        Boolean bDownload = (Boolean)componentDocuments.getSupportedFeatures().get(ComponentDocuments.Feature.DOWNLOAD);
        if (bDownload == null || !bDownload.booleanValue()) {
            throw new SystemException("ERR_DOWNLOAD_NOT_SUPPORTED", this.id);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        String fileId = this.path;
        if (!componentDocuments.existsDocument(fileId)) {
            throw new BadRequest("Image not found");
        }
        try {
            parameters.put("id", URLEncoder.encode(fileId, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        GetMethod method = new GetMethod(componentDocuments.getDownloadUrl(parameters));
        try {
            iStatus = oHttpClient.executeMethod((HttpMethod)method);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (iStatus == 404 || method.getResponseHeader("Content-Type") == null) {
            throw new BadRequest("Image not found");
        }
        try {
            input = method.getResponseBodyAsStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Resource(LibraryFile.getFilename((String)fileId), null, output.toByteArray());
    }

    public void onMalformedRequest(Throwable e) {
    }
}

