/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box;

import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.alexandria.http.AlexandriaHttpServer;
import io.intino.goros.unit.box.SetupServiceServiceAuthenticator;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.rest.resources.PostExecuteConstructorResource;
import io.intino.goros.unit.box.rest.resources.PostGetMajorVersionResource;
import io.intino.goros.unit.box.rest.resources.PostGetStatusResource;
import io.intino.goros.unit.box.rest.resources.PostPutLabelResource;
import io.intino.goros.unit.box.rest.resources.PostPutLogoResource;
import io.intino.goros.unit.box.rest.resources.PostRunResource;
import io.intino.goros.unit.box.rest.resources.PostShowApiResource;
import io.intino.goros.unit.box.rest.resources.PostStopResource;
import io.intino.goros.unit.box.rest.resources.PostUpdateModelResource;
import java.util.stream.Collectors;

public class SetupServiceService {
    private static SetupServiceServiceAuthenticator authenticator;

    public static AlexandriaHttpServer setup(AlexandriaHttpServer server, UnitBox box) {
        authenticator = new SetupServiceServiceAuthenticator(box);
        server.route("setupservice/showapi").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostShowApiResource(box, manager).execute());
        server.route("setupservice/getmajorversion").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostGetMajorVersionResource(box, manager).execute());
        server.route("setupservice/getstatus").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostGetStatusResource(box, manager).execute());
        server.route("setupservice/run").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostRunResource(box, manager).execute());
        server.route("setupservice/putlabel").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostPutLabelResource(box, manager).execute());
        server.route("setupservice/putlogo").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostPutLogoResource(box, manager).execute());
        server.route("setupservice/stop").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostStopResource(box, manager).execute());
        server.route("setupservice/updatemodel").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostUpdateModelResource(box, manager).execute());
        server.route("setupservice/executeconstructor").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostExecuteConstructorResource(box, manager).execute());
        return server;
    }
}

