/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.AlexandriaHttpServerBuilder;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.AlexandriaUiServer;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.UiElementsService;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.TranslatorService;
import io.intino.alexandria.ui.services.libraries.AlexandriaLibraryLoader;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.goros.unit.box.BackServiceService;
import io.intino.goros.unit.box.FmsServiceService;
import io.intino.goros.unit.box.FrontServiceService;
import io.intino.goros.unit.box.GeoServiceService;
import io.intino.goros.unit.box.I18n;
import io.intino.goros.unit.box.MobileServiceService;
import io.intino.goros.unit.box.SetupServiceService;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.UnitConfiguration;
import io.intino.goros.unit.box.ui.UnitElementsService;
import io.intino.goros.unit.box.ui.displays.RouteDispatcher;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends AlexandriaUiBox {
    protected UnitConfiguration configuration;
    protected Map<String, Soul> uiSouls = new HashMap<String, Soul>();
    private List<AlexandriaUiBox.SoulsClosed> soulsClosedListeners = new ArrayList<AlexandriaUiBox.SoulsClosed>();
    private AuthService authService;
    private List<AlexandriaLibraryLoader> libraryLoaders = new ArrayList<AlexandriaLibraryLoader>();

    public AbstractBox(String[] args) {
        this(new UnitConfiguration(args));
    }

    public AbstractBox(UnitConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    public UnitConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public abstract void beforeStart();

    public Box start() {
        this.initConnector();
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    public abstract void afterStart();

    public abstract void beforeStop();

    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    public void stopServices() {
        AlexandriaHttpServerBuilder.instance().stop();
    }

    public abstract void afterStop();

    public void startServices() {
        this.initUI();
        this.initAgenda();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
        this.initCli();
    }

    public List<Soul> souls() {
        return new ArrayList<Soul>(this.uiSouls.values());
    }

    public Optional<Soul> soul(String clientId) {
        return Optional.ofNullable(this.uiSouls.get(clientId));
    }

    public void registerSoul(String clientId, Soul soul) {
        this.uiSouls.put(clientId, soul);
    }

    public void unRegisterSoul(String clientId) {
        this.uiSouls.remove(clientId);
        if (this.uiSouls.size() <= 0) {
            this.notifySoulsClosed();
        }
    }

    public void onSoulsClosed(AlexandriaUiBox.SoulsClosed listener) {
        this.soulsClosedListeners.add(listener);
    }

    private void notifySoulsClosed() {
        this.soulsClosedListeners.forEach(l -> l.accept());
    }

    public boolean existsLibraryTemplate(String name) {
        return this.libraryLoaders.stream().anyMatch(l -> l.libraryTemplateEntryPointClass(name) != null);
    }

    protected abstract AuthService authService(URL var1);

    protected void beforeSetupUnitElementsUi(AlexandriaUiServer server) {
    }

    public void setupUnitElementsUi() {
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        this.authService = this.authService(AbstractBox.url(""));
        AlexandriaHttpServerBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (long)Long.parseLong("104857600"));
        AlexandriaHttpServerBuilder.setUI((boolean)true);
        AlexandriaHttpServerBuilder.addParameters((Object[])new Object[]{this.authService});
        this.pushService = this.owner != null && this.owner instanceof AlexandriaUiBox ? ((AlexandriaUiBox)this.owner).pushService() : new PushService();
        AlexandriaUiServer server = (AlexandriaUiServer)AlexandriaHttpServerBuilder.instance();
        this.beforeSetupUnitElementsUi(server);
        UnitElementsService.init(server, (UnitBox)this, this.pushService, new RouteDispatcher());
        UiElementsService.initDisplays((AlexandriaUiServer)server, (PushService)this.pushService);
    }

    private void initRestServices() {
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        AlexandriaHttpServerBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (long)Long.parseLong("104857600"));
        MobileServiceService.setup(AlexandriaHttpServerBuilder.instance(), (UnitBox)this);
        AlexandriaHttpServerBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info((String)("Rest service mobileService: started at port " + this.configuration().get("port") + "!"));
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        AlexandriaHttpServerBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (long)Long.parseLong("104857600"));
        FmsServiceService.setup(AlexandriaHttpServerBuilder.instance(), (UnitBox)this);
        AlexandriaHttpServerBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info((String)("Rest service fmsService: started at port " + this.configuration().get("port") + "!"));
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        AlexandriaHttpServerBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (long)Long.parseLong("104857600"));
        FrontServiceService.setup(AlexandriaHttpServerBuilder.instance(), (UnitBox)this);
        AlexandriaHttpServerBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info((String)("Rest service frontService: started at port " + this.configuration().get("port") + "!"));
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        AlexandriaHttpServerBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (long)Long.parseLong("104857600"));
        GeoServiceService.setup(AlexandriaHttpServerBuilder.instance(), (UnitBox)this);
        AlexandriaHttpServerBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info((String)("Rest service geoService: started at port " + this.configuration().get("port") + "!"));
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        AlexandriaHttpServerBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (long)Long.parseLong("104857600"));
        BackServiceService.setup(AlexandriaHttpServerBuilder.instance(), (UnitBox)this);
        AlexandriaHttpServerBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info((String)("Rest service backService: started at port " + this.configuration().get("port") + "!"));
        if (this.configuration().get("port") == null || this.configuration().get("port").isEmpty()) {
            return;
        }
        AlexandriaHttpServerBuilder.setup((int)Integer.parseInt(this.configuration().get("port")), (String)"www/", (long)Long.parseLong("104857600"));
        SetupServiceService.setup(AlexandriaHttpServerBuilder.instance(), (UnitBox)this);
        AlexandriaHttpServerBuilder.instance().start();
        io.intino.alexandria.logger.Logger.info((String)("Rest service setupService: started at port " + this.configuration().get("port") + "!"));
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
    }

    private void initSlackBots() {
    }

    private void initUI() {
        this.setupUnitElementsUi();
        this.initTranslatorService();
        AlexandriaUiServer serverUnitElementsInstance = (AlexandriaUiServer)AlexandriaHttpServerBuilder.instance();
        serverUnitElementsInstance.start();
        io.intino.alexandria.logger.Logger.info((String)("UI UnitElements: started at port " + this.configuration().get("port") + "!"));
    }

    private void initTranslatorService() {
        this.translatorService = new TranslatorService();
        this.translatorService.addAll(I18n.dictionaries());
        this.translatorService.addAll(io.intino.alexandria.I18n.dictionaries());
    }

    protected void initConnector() {
    }

    protected void initTerminal() {
    }

    protected void initSentinels() {
    }

    protected void initWorkflow() {
    }

    protected void initAgenda() {
    }

    protected void initCli() {
    }

    protected void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new io.intino.alexandria.logger.Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
        io.intino.alexandria.logger4j.Logger.init();
    }

    public static URL url(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return null;
        }
    }
}

