package io.intino.goros.unit.box.ui;
import io.intino.goros.unit.box.ui.displays.*;
import io.intino.goros.unit.box.ui.resources.*;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.UnitConfiguration;

import io.intino.alexandria.ui.AlexandriaUiServer;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifier;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import io.intino.alexandria.ui.resources.AssetResourceLoader;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.server.resources.AfterDisplayRequest;
import io.intino.alexandria.ui.server.resources.AssetResource;
import io.intino.alexandria.ui.server.resources.AuthenticateCallbackResource;
import io.intino.alexandria.ui.server.resources.BeforeDisplayRequest;

import java.net.MalformedURLException;
import java.net.URL;

public class UnitElementsService extends io.intino.alexandria.ui.UI {

	public static void init(AlexandriaUiServer server, UnitBox box, PushService pushService, DisplayRouteDispatcher routeDispatcher) {
		UnitConfiguration configuration = (UnitConfiguration) box.configuration();
		box.routeManager(routeManager(server, routeDispatcher));
        server.route("/_alexandria/push").register(pushService);
        server.route("/authenticate-callback").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
        server.route("/authenticate-callback/").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
        server.route("/asset/:name").get(manager -> new AssetResource(name -> new AssetResourceLoader(box).load(name), manager, notifierProvider()).execute());
		server.route("/alexandria/user").get(manager -> new HomeResource(box, manager, notifierProvider()).execute());
		server.route("/goros-home").get(manager -> new HomeResource(box, manager, notifierProvider()).execute());
		server.route("/install").get(manager -> new InstallResource(box, manager, notifierProvider()).execute());
		server.route("/banner.jsp").get(manager -> new BannerResource(box, manager, notifierProvider()).execute());
		initExposedDisplays(box, server, pushService);
		initProxyDisplays(box, server, pushService);
		initDisplays(server, pushService);
	}

	public static void initExposedDisplays(io.intino.alexandria.ui.AlexandriaUiBox box, AlexandriaUiServer server, PushService pushService) {

	}

	public static void initProxyDisplays(io.intino.alexandria.ui.AlexandriaUiBox box, AlexandriaUiServer server, PushService pushService) {

	}

	public static void initDisplays(AlexandriaUiServer server, PushService pushService) {
		initTaskToolbarTemplate(server, pushService);
		initTaskDownloadDialog(server, pushService);
		initSourceTemplate(server, pushService);
		initSourceEmbeddedTemplate(server, pushService);
		initSourceLevelTemplate(server, pushService);
		initSourceLegendTemplate(server, pushService);
		initPublishTermsDialog(server, pushService);
		initSourceTermDialog(server, pushService);
		initSourceTermTagTemplate(server, pushService);
		initTrashTemplate(server, pushService);
		initTrashToolbarTemplate(server, pushService);
		initTrashTableCatalog(server, pushService);
		initTrashTableFilters(server, pushService);
		initNodeDownloadDialog(server, pushService);
		initDashboardTemplate(server, pushService);
		initRolesTemplate(server, pushService);
		initRolesTableCatalog(server, pushService);
		initRolesToolbarTemplate(server, pushService);
		initRolesFiltersTemplate(server, pushService);
		initRoleEmbeddedTemplate(server, pushService);
		initSearchFilterTemplate(server, pushService);
		initListFilterTemplate(server, pushService);
		initComboFilterTemplate(server, pushService);
		initCheckFilterTemplate(server, pushService);
		initDateRangeFilterTemplate(server, pushService);
		initTaskStateViewTemplate(server, pushService);
		initTaskPlaceDelegationTemplate(server, pushService);
		initTaskPlaceRoleTemplate(server, pushService);
		initTaskPlaceSendJobTemplate(server, pushService);
		initTaskPlaceLineTemplate(server, pushService);
		initTaskPlaceLineStopTemplate(server, pushService);
		initTaskPlaceEditionTemplate(server, pushService);
		initTaskPlaceEnrollTemplate(server, pushService);
		initTaskPlaceWaitTemplate(server, pushService);
		initTaskPlaceSendRequestTemplate(server, pushService);
		initTaskPlaceSendResponseTemplate(server, pushService);
		initTaskHistoryTemplate(server, pushService);
		initTaskHistoryEntryTemplate(server, pushService);
		initTaskHistoryEntryLinkTemplate(server, pushService);
		initTaskOrdersTemplate(server, pushService);
		initTaskEmbeddedNodeTemplate(server, pushService);
		initTaskOrderTemplate(server, pushService);
		initNodeLinksInTemplate(server, pushService);
		initNodeLinksOutTemplate(server, pushService);
		initNodeRevisionsTemplate(server, pushService);
		initNodeNotesTemplate(server, pushService);
		initNodeLocationTemplate(server, pushService);
		initNodeDocumentTemplate(server, pushService);
		initFieldNodeTemplate(server, pushService);
		initTasksTableCatalog(server, pushService);
		initTasksListCatalog(server, pushService);
		initTasksToolbarTemplate(server, pushService);
		initTasksFiltersTemplate(server, pushService);
		initGorosAppTemplate(server, pushService);
		initGorosInstallTemplate(server, pushService);
		initBusinessUnitsTemplate(server, pushService);
		initBusinessUnitTemplate(server, pushService);
		initDownloadDialogOption(server, pushService);
		initNewsTemplate(server, pushService);
		initAssignTaskDialogTableFullnameItem(server, pushService);
		initAssignTaskDialogTableEmailItem(server, pushService);
		initSourceLevelListItem(server, pushService);
		initTrashTableTypeItem(server, pushService);
		initTrashTableLabelItem(server, pushService);
		initTrashTableDeleteDateItem(server, pushService);
		initTrashTableOperationsItem(server, pushService);
		initRolesTableUserItem(server, pushService);
		initRolesTableDefinitionItem(server, pushService);
		initRolesTableTypeItem(server, pushService);
		initRolesTableNatureItem(server, pushService);
		initRolesTableStartDateItem(server, pushService);
		initRolesTableEndDateItem(server, pushService);
		initRolesTableOperationsItem(server, pushService);
		initAddRoleUserTableFullnameItem(server, pushService);
		initAddRoleUserTableEmailItem(server, pushService);
		initAddRoleServiceTableLabelItem(server, pushService);
		initAddRoleServiceTablePartnerItem(server, pushService);
		initAddRoleFeederTableLabelItem(server, pushService);
		initAddRoleFeederTablePartnerItem(server, pushService);
		initComboFilterTemplateMold(server, pushService);
		initLinksInTableLabelItem(server, pushService);
		initLinksInTableDescriptionItem(server, pushService);
		initLinksOutTableLabelItem(server, pushService);
		initLinksOutTableDescriptionItem(server, pushService);
		initNodeRevisionsTableLabelItem(server, pushService);
		initNodeRevisionsTableOperationsItem(server, pushService);
		initNodeNotesTableNameItem(server, pushService);
		initNodeNotesTableValueItem(server, pushService);
		initNodeNotesTableOperationsItem(server, pushService);
		initTasksTableLabelItem(server, pushService);
		initTasksTableOwnerItem(server, pushService);
		initTasksTableCreateDateItem(server, pushService);
		initTasksTableUpdateDateItem(server, pushService);
		initTasksTableCountMessagesItem(server, pushService);
		initTasksTableOperationsItem(server, pushService);
		initTasksListItem(server, pushService);
		initNewsListItem(server, pushService);
		initAssignTaskDialogTableRow(server, pushService);
		initTrashTableRow(server, pushService);
		initRolesTableRow(server, pushService);
		initAddRoleUserTableRow(server, pushService);
		initAddRoleServiceTableRow(server, pushService);
		initAddRoleFeederTableRow(server, pushService);
		initLinksInTableRow(server, pushService);
		initLinksOutTableRow(server, pushService);
		initNodeRevisionsTableRow(server, pushService);
		initNodeNotesTableRow(server, pushService);
		initTasksTableRow(server, pushService);
		registerNotifiers();
	}

	private static void registerNotifiers() {
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskToolbarTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskDownloadDialog.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.SourceTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.SourceEmbeddedTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.SourceLevelTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.SourceLegendTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.PublishTermsDialog.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.SourceTermDialog.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.SourceTermTagTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TrashTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TrashToolbarTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TrashTableCatalog.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TrashTableFilters.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.NodeDownloadDialog.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.DashboardTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.RolesTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.RolesTableCatalog.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.RolesToolbarTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.RolesFiltersTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.RoleEmbeddedTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.SearchFilterTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.ListFilterTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.ComboFilterTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.CheckFilterTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.DateRangeFilterTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskStateViewTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskPlaceDelegationTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskPlaceRoleTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskPlaceSendJobTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskPlaceLineTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskPlaceLineStopTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskPlaceEditionTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskPlaceEnrollTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskPlaceWaitTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskPlaceSendRequestTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskPlaceSendResponseTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskHistoryTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskHistoryEntryTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskHistoryEntryLinkTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskOrdersTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskEmbeddedNodeTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TaskOrderTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.NodeLinksInTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.NodeLinksOutTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.NodeRevisionsTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.NodeNotesTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.NodeLocationTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.NodeDocumentTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.FieldNodeTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TasksTableCatalog.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TasksListCatalog.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TasksToolbarTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.TasksFiltersTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.GorosAppTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.GorosInstallTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.BusinessUnitsTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.BusinessUnitTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.DownloadDialogOption.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.templates.NewsTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.AssignTaskDialogTableFullnameItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.AssignTaskDialogTableEmailItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.SourceLevelListItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.TrashTableTypeItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.TrashTableLabelItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.TrashTableDeleteDateItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.TrashTableOperationsItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.RolesTableUserItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.RolesTableDefinitionItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.RolesTableTypeItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.RolesTableNatureItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.RolesTableStartDateItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.RolesTableEndDateItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.RolesTableOperationsItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.AddRoleUserTableFullnameItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.AddRoleUserTableEmailItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.AddRoleServiceTableLabelItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.AddRoleServiceTablePartnerItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.AddRoleFeederTableLabelItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.AddRoleFeederTablePartnerItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.ComboFilterTemplateMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.LinksInTableLabelItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.LinksInTableDescriptionItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.LinksOutTableLabelItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.LinksOutTableDescriptionItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.NodeRevisionsTableLabelItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.NodeRevisionsTableOperationsItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.NodeNotesTableNameItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.NodeNotesTableValueItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.NodeNotesTableOperationsItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.TasksTableLabelItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.TasksTableOwnerItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.TasksTableCreateDateItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.TasksTableUpdateDateItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.TasksTableCountMessagesItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.TasksTableOperationsItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.TasksListItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.items.NewsListItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.rows.AssignTaskDialogTableRow.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.rows.TrashTableRow.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.rows.RolesTableRow.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.rows.AddRoleUserTableRow.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.rows.AddRoleServiceTableRow.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.rows.AddRoleFeederTableRow.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.rows.LinksInTableRow.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.rows.LinksOutTableRow.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.rows.NodeRevisionsTableRow.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.rows.NodeNotesTableRow.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.goros.unit.box.ui.displays.rows.TasksTableRow.class);
	}

	private static void initTaskToolbarTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/tasktoolbartemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/tasktoolbartemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/tasktoolbartemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("tasktoolbartemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskDownloadDialog(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskdownloaddialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskdownloaddialog/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskdownloaddialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskdownloaddialog", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initSourceTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/sourcetemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sourcetemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/sourcetemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sourcetemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initSourceEmbeddedTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/sourceembeddedtemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sourceembeddedtemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/sourceembeddedtemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sourceembeddedtemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initSourceLevelTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/sourceleveltemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sourceleveltemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/sourceleveltemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sourceleveltemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initSourceLegendTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/sourcelegendtemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sourcelegendtemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/sourcelegendtemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sourcelegendtemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initPublishTermsDialog(AlexandriaUiServer server, PushService pushService) {
		server.route("/publishtermsdialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/publishtermsdialog/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/publishtermsdialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("publishtermsdialog", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initSourceTermDialog(AlexandriaUiServer server, PushService pushService) {
		server.route("/sourcetermdialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sourcetermdialog/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/sourcetermdialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sourcetermdialog", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initSourceTermTagTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/sourcetermtagtemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sourcetermtagtemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/sourcetermtagtemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sourcetermtagtemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTrashTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/trashtemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/trashtemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/trashtemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("trashtemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTrashToolbarTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/trashtoolbartemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/trashtoolbartemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/trashtoolbartemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("trashtoolbartemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTrashTableCatalog(AlexandriaUiServer server, PushService pushService) {
		server.route("/trashtablecatalog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/trashtablecatalog/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/trashtablecatalog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("trashtablecatalog", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTrashTableFilters(AlexandriaUiServer server, PushService pushService) {
		server.route("/trashtablefilters/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/trashtablefilters/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/trashtablefilters/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("trashtablefilters", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initNodeDownloadDialog(AlexandriaUiServer server, PushService pushService) {
		server.route("/nodedownloaddialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/nodedownloaddialog/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/nodedownloaddialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("nodedownloaddialog", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDashboardTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/dashboardtemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/dashboardtemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/dashboardtemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dashboardtemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initRolesTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolestemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolestemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/rolestemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolestemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initRolesTableCatalog(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolestablecatalog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolestablecatalog/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/rolestablecatalog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolestablecatalog", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initRolesToolbarTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolestoolbartemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolestoolbartemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/rolestoolbartemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolestoolbartemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initRolesFiltersTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolesfilterstemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolesfilterstemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/rolesfilterstemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolesfilterstemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initRoleEmbeddedTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/roleembeddedtemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/roleembeddedtemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/roleembeddedtemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("roleembeddedtemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initSearchFilterTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/searchfiltertemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/searchfiltertemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/searchfiltertemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("searchfiltertemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initListFilterTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/listfiltertemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/listfiltertemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/listfiltertemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("listfiltertemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initComboFilterTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/combofiltertemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/combofiltertemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/combofiltertemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("combofiltertemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initCheckFilterTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/checkfiltertemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/checkfiltertemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/checkfiltertemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("checkfiltertemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDateRangeFilterTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/daterangefiltertemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/daterangefiltertemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/daterangefiltertemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("daterangefiltertemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskStateViewTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskstateviewtemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskstateviewtemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskstateviewtemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskstateviewtemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskPlaceDelegationTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskplacedelegationtemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskplacedelegationtemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskplacedelegationtemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskplacedelegationtemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskPlaceRoleTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskplaceroletemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskplaceroletemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskplaceroletemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskplaceroletemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskPlaceSendJobTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskplacesendjobtemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskplacesendjobtemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskplacesendjobtemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskplacesendjobtemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskPlaceLineTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskplacelinetemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskplacelinetemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskplacelinetemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskplacelinetemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskPlaceLineStopTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskplacelinestoptemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskplacelinestoptemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskplacelinestoptemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskplacelinestoptemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskPlaceEditionTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskplaceeditiontemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskplaceeditiontemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskplaceeditiontemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskplaceeditiontemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskPlaceEnrollTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskplaceenrolltemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskplaceenrolltemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskplaceenrolltemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskplaceenrolltemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskPlaceWaitTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskplacewaittemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskplacewaittemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskplacewaittemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskplacewaittemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskPlaceSendRequestTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskplacesendrequesttemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskplacesendrequesttemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskplacesendrequesttemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskplacesendrequesttemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskPlaceSendResponseTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskplacesendresponsetemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskplacesendresponsetemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskplacesendresponsetemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskplacesendresponsetemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskHistoryTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskhistorytemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskhistorytemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskhistorytemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskhistorytemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskHistoryEntryTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskhistoryentrytemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskhistoryentrytemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskhistoryentrytemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskhistoryentrytemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskHistoryEntryLinkTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskhistoryentrylinktemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskhistoryentrylinktemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskhistoryentrylinktemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskhistoryentrylinktemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskOrdersTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskorderstemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskorderstemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskorderstemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskorderstemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskEmbeddedNodeTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskembeddednodetemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskembeddednodetemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskembeddednodetemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskembeddednodetemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTaskOrderTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskordertemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskordertemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskordertemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskordertemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initNodeLinksInTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/nodelinksintemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/nodelinksintemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/nodelinksintemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("nodelinksintemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initNodeLinksOutTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/nodelinksouttemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/nodelinksouttemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/nodelinksouttemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("nodelinksouttemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initNodeRevisionsTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/noderevisionstemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/noderevisionstemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/noderevisionstemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("noderevisionstemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initNodeNotesTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/nodenotestemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/nodenotestemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/nodenotestemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("nodenotestemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initNodeLocationTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/nodelocationtemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/nodelocationtemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/nodelocationtemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("nodelocationtemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initNodeDocumentTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/nodedocumenttemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/nodedocumenttemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/nodedocumenttemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("nodedocumenttemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initFieldNodeTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/fieldnodetemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/fieldnodetemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/fieldnodetemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("fieldnodetemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTasksTableCatalog(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskstablecatalog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskstablecatalog/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskstablecatalog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskstablecatalog", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTasksListCatalog(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskslistcatalog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskslistcatalog/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskslistcatalog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskslistcatalog", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTasksToolbarTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskstoolbartemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskstoolbartemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/taskstoolbartemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskstoolbartemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initTasksFiltersTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/tasksfilterstemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/tasksfilterstemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/tasksfilterstemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("tasksfilterstemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initGorosAppTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/gorosapptemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/gorosapptemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/gorosapptemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("gorosapptemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initGorosInstallTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/gorosinstalltemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/gorosinstalltemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/gorosinstalltemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("gorosinstalltemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initBusinessUnitsTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/businessunitstemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/businessunitstemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/businessunitstemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("businessunitstemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initBusinessUnitTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/businessunittemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/businessunittemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/businessunittemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("businessunittemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initDownloadDialogOption(AlexandriaUiServer server, PushService pushService) {
		server.route("/downloaddialogoption/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/downloaddialogoption/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/downloaddialogoption/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("downloaddialogoption", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initNewsTemplate(AlexandriaUiServer server, PushService pushService) {
		server.route("/newstemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/newstemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		server.route("/newstemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("newstemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

	}
	private static void initAssignTaskDialogTableFullnameItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/assigntaskdialogtablefullnameitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/assigntaskdialogtablefullnameitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/assigntaskdialogtablefullnameitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("assigntaskdialogtablefullnameitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initAssignTaskDialogTableEmailItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/assigntaskdialogtableemailitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/assigntaskdialogtableemailitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/assigntaskdialogtableemailitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("assigntaskdialogtableemailitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initSourceLevelListItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/sourcelevellistitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/sourcelevellistitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/sourcelevellistitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sourcelevellistitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTrashTableTypeItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/trashtabletypeitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/trashtabletypeitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/trashtabletypeitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("trashtabletypeitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTrashTableLabelItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/trashtablelabelitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/trashtablelabelitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/trashtablelabelitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("trashtablelabelitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTrashTableDeleteDateItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/trashtabledeletedateitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/trashtabledeletedateitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/trashtabledeletedateitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("trashtabledeletedateitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTrashTableOperationsItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/trashtableoperationsitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/trashtableoperationsitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/trashtableoperationsitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("trashtableoperationsitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initRolesTableUserItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolestableuseritem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolestableuseritem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/rolestableuseritem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolestableuseritem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initRolesTableDefinitionItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolestabledefinitionitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolestabledefinitionitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/rolestabledefinitionitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolestabledefinitionitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initRolesTableTypeItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolestabletypeitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolestabletypeitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/rolestabletypeitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolestabletypeitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initRolesTableNatureItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolestablenatureitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolestablenatureitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/rolestablenatureitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolestablenatureitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initRolesTableStartDateItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolestablestartdateitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolestablestartdateitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/rolestablestartdateitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolestablestartdateitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initRolesTableEndDateItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolestableenddateitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolestableenddateitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/rolestableenddateitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolestableenddateitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initRolesTableOperationsItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolestableoperationsitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolestableoperationsitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/rolestableoperationsitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolestableoperationsitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initAddRoleUserTableFullnameItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/addroleusertablefullnameitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/addroleusertablefullnameitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/addroleusertablefullnameitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("addroleusertablefullnameitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initAddRoleUserTableEmailItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/addroleusertableemailitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/addroleusertableemailitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/addroleusertableemailitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("addroleusertableemailitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initAddRoleServiceTableLabelItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/addroleservicetablelabelitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/addroleservicetablelabelitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/addroleservicetablelabelitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("addroleservicetablelabelitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initAddRoleServiceTablePartnerItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/addroleservicetablepartneritem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/addroleservicetablepartneritem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/addroleservicetablepartneritem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("addroleservicetablepartneritem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initAddRoleFeederTableLabelItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/addrolefeedertablelabelitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/addrolefeedertablelabelitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/addrolefeedertablelabelitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("addrolefeedertablelabelitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initAddRoleFeederTablePartnerItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/addrolefeedertablepartneritem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/addrolefeedertablepartneritem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/addrolefeedertablepartneritem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("addrolefeedertablepartneritem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initComboFilterTemplateMold(AlexandriaUiServer server, PushService pushService) {
		server.route("/combofiltertemplatemold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/combofiltertemplatemold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/combofiltertemplatemold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("combofiltertemplatemold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initLinksInTableLabelItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/linksintablelabelitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/linksintablelabelitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/linksintablelabelitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("linksintablelabelitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initLinksInTableDescriptionItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/linksintabledescriptionitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/linksintabledescriptionitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/linksintabledescriptionitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("linksintabledescriptionitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initLinksOutTableLabelItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/linksouttablelabelitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/linksouttablelabelitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/linksouttablelabelitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("linksouttablelabelitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initLinksOutTableDescriptionItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/linksouttabledescriptionitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/linksouttabledescriptionitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/linksouttabledescriptionitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("linksouttabledescriptionitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initNodeRevisionsTableLabelItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/noderevisionstablelabelitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/noderevisionstablelabelitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/noderevisionstablelabelitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("noderevisionstablelabelitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initNodeRevisionsTableOperationsItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/noderevisionstableoperationsitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/noderevisionstableoperationsitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/noderevisionstableoperationsitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("noderevisionstableoperationsitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initNodeNotesTableNameItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/nodenotestablenameitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/nodenotestablenameitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/nodenotestablenameitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("nodenotestablenameitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initNodeNotesTableValueItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/nodenotestablevalueitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/nodenotestablevalueitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/nodenotestablevalueitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("nodenotestablevalueitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initNodeNotesTableOperationsItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/nodenotestableoperationsitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/nodenotestableoperationsitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/nodenotestableoperationsitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("nodenotestableoperationsitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTasksTableLabelItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskstablelabelitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskstablelabelitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/taskstablelabelitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskstablelabelitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTasksTableOwnerItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskstableowneritem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskstableowneritem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/taskstableowneritem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskstableowneritem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTasksTableCreateDateItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskstablecreatedateitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskstablecreatedateitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/taskstablecreatedateitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskstablecreatedateitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTasksTableUpdateDateItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskstableupdatedateitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskstableupdatedateitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/taskstableupdatedateitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskstableupdatedateitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTasksTableCountMessagesItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskstablecountmessagesitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskstablecountmessagesitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/taskstablecountmessagesitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskstablecountmessagesitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTasksTableOperationsItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskstableoperationsitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskstableoperationsitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/taskstableoperationsitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskstableoperationsitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initTasksListItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskslistitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskslistitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/taskslistitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskslistitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initNewsListItem(AlexandriaUiServer server, PushService pushService) {
		server.route("/newslistitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/newslistitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		server.route("/newslistitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("newslistitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

	}
	private static void initAssignTaskDialogTableRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/assigntaskdialogtablerow/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/assigntaskdialogtablerow/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/assigntaskdialogtablerow/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("assigntaskdialogtablerow", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initTrashTableRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/trashtablerow/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/trashtablerow/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/trashtablerow/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("trashtablerow", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initRolesTableRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/rolestablerow/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/rolestablerow/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/rolestablerow/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("rolestablerow", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initAddRoleUserTableRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/addroleusertablerow/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/addroleusertablerow/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/addroleusertablerow/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("addroleusertablerow", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initAddRoleServiceTableRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/addroleservicetablerow/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/addroleservicetablerow/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/addroleservicetablerow/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("addroleservicetablerow", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initAddRoleFeederTableRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/addrolefeedertablerow/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/addrolefeedertablerow/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/addrolefeedertablerow/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("addrolefeedertablerow", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initLinksInTableRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/linksintablerow/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/linksintablerow/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/linksintablerow/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("linksintablerow", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initLinksOutTableRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/linksouttablerow/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/linksouttablerow/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/linksouttablerow/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("linksouttablerow", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initNodeRevisionsTableRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/noderevisionstablerow/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/noderevisionstablerow/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/noderevisionstablerow/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("noderevisionstablerow", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initNodeNotesTableRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/nodenotestablerow/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/nodenotestablerow/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/nodenotestablerow/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("nodenotestablerow", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
	private static void initTasksTableRow(AlexandriaUiServer server, PushService pushService) {
		server.route("/taskstablerow/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		server.route("/taskstablerow/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		server.route("/taskstablerow/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("taskstablerow", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

	}
}