package io.intino.goros.unit.box.rest.resources;

import java.util.List;
import java.util.Set;
import java.util.ArrayList;
import io.intino.alexandria.exceptions.*;
import io.intino.goros.unit.box.*;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.*;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.http.pushservice.PushService;

import io.intino.goros.unit.box.schemas.*;

public class PostSourceResource implements Resource {

	private UnitBox box;
	private AlexandriaHttpManager<PushService<?,?>> manager;

	public PostSourceResource(UnitBox box, AlexandriaHttpManager manager) {
		this.box = box;
		this.manager = manager;
	}

	public void execute() throws AlexandriaException {
		write(fill(new io.intino.goros.unit.box.actions.PostSourceAction()).execute());
	}

	private io.intino.goros.unit.box.actions.PostSourceAction fill(io.intino.goros.unit.box.actions.PostSourceAction action) throws AlexandriaException {
		action.box = this.box;
		action.context = context();
		try {
			action.action = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("action"), String.class);
			action.source = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromPath("source"), String.class);
			action.mode = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("mode"), String.class);
			action.flatten = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("flatten"), String.class);
			action.depth = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("depth"), String.class);
			action.from = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("from"), String.class);
			action.filters = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("filters"), String.class);
			action.searchText = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("search-text"), String.class);
			action.startPos = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("start-pos"), String.class);
			action.count = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("count"), String.class);
		} catch (Throwable e) {
			action.onMalformedRequest(e);
		}
		return action;
	}

	private void write(String object) {
		manager.write(io.intino.alexandria.rest.ResponseAdapter.adapt(object));
	}

	private io.intino.alexandria.http.server.AlexandriaHttpContext context() {
		io.intino.alexandria.http.server.AlexandriaHttpContext context = new io.intino.alexandria.http.server.AlexandriaHttpContext(manager);

		context.put("pathInfo", manager.request().raw().getPathInfo());
		context.put("ip", manager.ip());
		return context;
	}
}