/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.TaskListDatasource;
import io.intino.goros.unit.box.ui.displays.rows.TasksTableRow;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTasksTableCatalog;
import io.intino.goros.unit.util.DisplayHelper;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import io.intino.goros.unit.util.TaskHelper;
import java.util.Collections;
import org.monet.space.kernel.model.Task;

public class TasksTableCatalog
extends AbstractTasksTableCatalog<UnitBox> {
    private boolean readonly = true;
    private Task selected = null;
    private TaskListDatasource source;

    public TasksTableCatalog(UnitBox box) {
        super(box);
    }

    public TasksTableCatalog source(TaskListDatasource source) {
        if (this.source == source) {
            return this;
        }
        this.source = source;
        this.tasksTable.source((Datasource)source);
        return this;
    }

    public TasksTableCatalog readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public void select(Task task) {
        DisplayHelper.executeDelayed(b -> this.tasksTable.select(this.tasksTable.findItem(t -> ((Task)t).getId().equals(task.getId()))), 800L);
    }

    public void selectSorting(String sorting, String mode) {
        this.tasksTable.sortings(sorting != null ? Collections.singletonList(NodeHelper.sortingOf(sorting, mode)) : Collections.emptyList());
    }

    public void refresh(Task task) {
        this.tasksTable.refresh(this.tasksTable.findItem(t -> ((Task)t).getId().equals(task.getId())), task);
    }

    @Override
    public void init() {
        super.init();
        this.tasksTable.onAddItem(this::refreshTask);
        this.taskComments.onOpen(e -> this.refreshTaskComments());
    }

    private void refreshTask(AddItemEvent event) {
        this.refreshTask((Task)event.item(), (TasksTableRow)event.component());
    }

    private void refreshTask(Task<?> task, TasksTableRow display) {
        String comments = task.getComments();
        display.tasksTableLabelItem.label.value(task.getLabel());
        display.tasksTableLabelItem.state.value(this.translate(TaskHelper.state(task)));
        display.tasksTableLabelItem.state.backgroundColor(TaskHelper.stateColor(task));
        display.tasksTableOwnerItem.owner.value(task.getOwner() != null ? task.getOwner().getInfo().getFullname() : null);
        display.tasksTableCountMessagesItem.countMessages.value(task.getNewMessagesCount());
        display.tasksTableCreateDateItem.createDate.value(task.getInternalCreateDate().toInstant());
        display.tasksTableUpdateDateItem.updateDate.value(task.getInternalUpdateDate().toInstant());
        display.tasksTableOperationsItem.commentsTrigger.readonly(comments == null || comments.isEmpty());
        display.tasksTableOperationsItem.commentsTrigger.bindTo(this.taskComments);
        display.tasksTableOperationsItem.commentsTrigger.onOpen(e -> this.refreshTaskComments(task));
        display.tasksTableOperationsItem.urgent.onExecute(e -> this.toggleUrgent(task, display));
        display.tasksTableOperationsItem.urgent.color(task.isUrgent() ? "#F44335" : "#ddd");
    }

    private void refreshTaskComments(Task<?> task) {
        this.selected = task;
        this.refreshTaskComments();
    }

    private void refreshTaskComments() {
        if (this.selected == null) {
            return;
        }
        this.taskComments.comments.content(this.selected.getComments().replace("\n", "<br/>"));
        this.taskComments.comments.refresh();
    }

    private void toggleUrgent(Task<?> task, TasksTableRow display) {
        task.setUrgent(!task.isUrgent());
        LayerHelper.taskLayer().saveTaskUrgency(task);
        this.refreshTask(task, display);
    }

    public void refresh() {
        super.refresh();
        this.tasksTable.reload();
    }
}

