/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.editable.Editable;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.events.ChangeListener;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.DisplayProvider;
import io.intino.goros.unit.box.ui.displays.templates.AbstractFieldNodeTemplate;
import io.intino.goros.unit.util.DisplayHelper;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.monet.bpi.FieldNode;
import org.monet.bpi.types.Link;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.NodeFieldProperty;
import org.monet.metamodel.NodeFieldPropertyBase;
import org.monet.metamodel.NodeViewProperty;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.Language;
import org.monet.space.kernel.model.Node;

public class FieldNodeTemplate
extends AbstractFieldNodeTemplate<UnitBox>
implements Editable<TemplateNotifier, UnitBox> {
    private Node node;
    private FieldNode field;
    private boolean readonly;
    private DisplayProvider displayProvider;
    private ChangeListener changeListener;

    public FieldNodeTemplate(UnitBox box) {
        super(box);
    }

    public FieldNodeTemplate node(Node node) {
        this.node = node;
        return this;
    }

    public FieldNodeTemplate field(FieldNode field) {
        this.field = field;
        return this;
    }

    public boolean readonly() {
        return this.readonly;
    }

    public void reload() {
        this.refresh();
    }

    public Editable<TemplateNotifier, UnitBox> focus() {
        return this;
    }

    public FieldNodeTemplate readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public FieldNodeTemplate onChange(ChangeListener changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public FieldNodeTemplate displayProvider(DisplayProvider provider) {
        this.displayProvider = provider;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.initToolbar();
        this.nodeDialog.onOpen(e -> this.refreshNodeDialog());
    }

    private void refreshNodeDialog() {
        Node node = this.loadNode();
        this.nodeDialog.title(node != null ? node.getLabel() : this.translate("No label"));
        this.refreshNode(node);
    }

    private void initToolbar() {
        this.addType.onExecute(e -> this.addNode());
        this.selectNodeTypeDialog.onSelect(e -> {
            if (e.selection().size() <= 0) {
                return;
            }
            this.addNode((String)e.selection().get(0));
        });
    }

    public void refresh() {
        super.refresh();
        Node node = this.loadNode();
        this.title.value(Language.getInstance().getModelResource(this.field.getDefinition().getLabel()));
        this.refreshToolbar(node);
        this.refreshSelectNodeTypeDialog();
        this.openNodeTrigger.title(this.translate("Open") + "...");
        this.openNodeTrigger.visible(node != null);
        this.refreshEmptyBlock(node);
    }

    private Node loadNode() {
        Link link = (Link)this.field.get();
        if (link == null || link.getId().isEmpty()) {
            return null;
        }
        return LayerHelper.nodeLayer().loadNode(link.getId());
    }

    private void refreshToolbar(Node node) {
        List<NodeDefinition> types = this.types();
        this.addType.visible(node == null && types.size() == 1);
        this.addType.readonly(this.readonly);
        this.selectType.visible(node == null && types.size() > 1);
        this.selectType.readonly(this.readonly);
    }

    private void refreshSelectNodeTypeDialog() {
        this.selectNodeTypeDialog.onOpen(e -> {
            this.nodeTypeSeletor.clear();
            this.types().forEach(type -> this.nodeTypeSeletor.add(type.getLabelString()));
        });
    }

    private void refreshNode(Node node) {
        this.nodeFrame.clear();
        if (node == null) {
            return;
        }
        NodeViewProperty viewProperty = DisplayHelper.defaultEmbeddedView(node);
        Display display = this.displayProvider.displayFor(node, viewProperty != null ? viewProperty.getCode() : null);
        if (display == null) {
            return;
        }
        this.nodeFrame.display(display);
        display.refresh();
    }

    private void refreshEmptyBlock(Node node) {
        this.emptyBlock.visible(node == null);
    }

    private void addNode() {
        this.addNode(this.types().get(0).getLabelString());
    }

    private void addNode(String type) {
        NodeDefinition nodeDefinition = this.types().stream().filter(t -> t.getLabelString().equals(type)).findFirst().orElse(null);
        Node node = LayerHelper.nodeLayer().addNode(nodeDefinition.getCode());
        this.field.set((Object)NodeHelper.linkOf(node));
        this.refresh();
        this.changeListener.accept(new ChangeEvent((Display)this, (Object)this.field));
    }

    private List<NodeDefinition> types() {
        Dictionary dictionary = Dictionary.getInstance();
        NodeFieldPropertyBase.AddProperty add = ((NodeFieldProperty)this.field.getDefinition()).getAdd();
        if (add == null) {
            return Collections.emptyList();
        }
        return add.getNode().stream().map(ref -> dictionary.getNodeDefinition(ref.getValue())).collect(Collectors.toList());
    }
}

