/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.util.LayerHelper;
import java.text.Normalizer;
import java.util.Arrays;
import org.monet.space.kernel.model.FederationUnit;
import org.monet.space.kernel.model.FederationUnitFeeder;
import org.monet.space.kernel.model.FederationUnitService;

public class DatasourceHelper {
    public static String partnerLabel(UISession session, FederationUnitFeeder feeder) {
        return DatasourceHelper.partnerLabel(session, feeder.getLabel());
    }

    public static String partnerLabel(UISession session, FederationUnitService service) {
        return DatasourceHelper.partnerLabel(session, service.getPartnerId());
    }

    public static String partnerLabel(UISession session, String partnerId) {
        return DatasourceHelper.partner(session, partnerId).getLabel();
    }

    public static FederationUnit partner(UISession session, String partnerId) {
        return LayerHelper.federationLayer(session).loadPartner(partnerId);
    }

    public static boolean matches(String value, String[] conditions) {
        if (value == null) {
            return false;
        }
        String cleanedValue = DatasourceHelper.clean(value.toLowerCase());
        return Arrays.stream(conditions).allMatch(c -> cleanedValue.contains(DatasourceHelper.clean(c)));
    }

    private static String clean(String value) {
        value = Normalizer.normalize(value, Normalizer.Form.NFD);
        value = value.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return value;
    }
}

