/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box;

import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.goros.unit.box.FrontServiceServiceAuthenticator;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.rest.resources.PostBusinessResource;
import io.intino.goros.unit.box.rest.resources.PostMailboxResource;
import io.intino.goros.unit.box.rest.resources.PostSourceResource;
import java.util.stream.Collectors;

public class FrontServiceService {
    private static FrontServiceServiceAuthenticator authenticator;

    public static AlexandriaSpark setup(AlexandriaSpark server, UnitBox box) {
        authenticator = new FrontServiceServiceAuthenticator(box);
        server.route("service/source/:source-name/").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostSourceResource(box, manager).execute());
        server.route("service/mailbox/:address/").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostMailboxResource(box, manager).execute());
        server.route("service/business/:service-name/").before(manager -> {
            if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) {
                throw new Unauthorized("Credential not found");
            }
        }).post(manager -> new PostBusinessResource(box, manager).execute());
        return server;
    }
}

