package io.intino.goros.unit.box.rest.resources;

import java.util.List;
import java.util.ArrayList;
import io.intino.alexandria.exceptions.*;
import io.intino.goros.unit.box.*;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.*;
import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.http.spark.SparkPushService;

import io.intino.goros.unit.box.schemas.*;

public class PostMailboxResource implements Resource {

	private UnitBox box;
	private SparkManager<SparkPushService> manager;

	public PostMailboxResource(UnitBox box, SparkManager manager) {
		this.box = box;
		this.manager = manager;
	}

	public void execute() throws AlexandriaException {
		write(fill(new io.intino.goros.unit.box.actions.PostMailboxAction()).execute());
	}

	private io.intino.goros.unit.box.actions.PostMailboxAction fill(io.intino.goros.unit.box.actions.PostMailboxAction action) {
		action.box = this.box;
		action.context = context();
		action.address = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromPath("address"), String.class);
		action.signaling = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("signaling"), String.class);
		action.message = manager.fromPartAsResource("message");
		action.messageCode = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("message-code"), String.class);
		action.messageType = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("message-type"), String.class);
		action.messageHash = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("message-hash"), String.class);
		return action;
	}

	private void write(String object) {
		manager.write(io.intino.alexandria.rest.ResponseAdapter.adapt(object));
	}

	private io.intino.alexandria.http.spark.SparkContext context() {
		io.intino.alexandria.http.spark.SparkContext context = new io.intino.alexandria.http.spark.SparkContext(manager);

		context.put("ip", manager.ip());
		return context;
	}
}