package io.intino.goros.unit.box;

import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.goros.unit.box.rest.resources.*;
import io.intino.alexandria.core.Box;

public class GeoServiceService {

	public static AlexandriaSpark setup(AlexandriaSpark server, UnitBox box) {
		server.route("1.0/api/geoservice/definitions").get(manager -> new GetDefinitionsResource(box, manager).execute());
		server.route("1.0/api/geoservice/locations/:name").get(manager -> new GetLocationsResource(box, manager).execute());
		server.route("1.0/api/geoservice/locations/:name/:owner").get(manager -> new GetLocationsByOwnerResource(box, manager).execute());
		server.route("1.0/api/geoservice/location/:id").get(manager -> new GetLocationsFromNodeResource(box, manager).execute());
		server.route("1.0/api/geoservice/image/:id/:path").get(manager -> new GetImagesResource(box, manager).execute());

		return server;
	}
}