/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.util.LayerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.monet.space.kernel.components.layers.FederationLayer;
import org.monet.space.kernel.model.DataRequest;
import org.monet.space.kernel.model.User;
import org.monet.space.kernel.model.UserList;

public class UserListDatasource
extends PageDatasource<User> {
    private final UnitBox box;
    private final UISession session;
    private final boolean federationUsers;

    public UserListDatasource(UnitBox box, UISession session, boolean federationUsers) {
        this.box = box;
        this.session = session;
        this.federationUsers = federationUsers;
    }

    public List<User> items(int start, int count, String condition, List<Filter> filters, List<String> sortings) {
        DataRequest request = this.request(condition, filters);
        request.setStartPos(Integer.valueOf(start));
        request.setLimit(Integer.valueOf(count));
        return new ArrayList<User>(UserListDatasource.users(request, this.box, this.session, this.federationUsers));
    }

    public long itemCount(String condition, List<Filter> filters) {
        return UserListDatasource.users(this.request(condition, filters), this.box, this.session, this.federationUsers).size();
    }

    public List<Group> groups(String key) {
        return Collections.emptyList();
    }

    public static long itemCount(UnitBox box, UISession session, boolean federationUsers) {
        return UserListDatasource.users(UserListDatasource.request(), box, session, federationUsers).size();
    }

    private static List<User> users(DataRequest request, UnitBox box, UISession session, boolean federationUsers) {
        box.linkSession(session);
        FederationLayer federationLayer = LayerHelper.federationLayer(session);
        UserList users = federationUsers ? federationLayer.searchFederationUsers(request) : federationLayer.searchUsersWithRoles(request);
        return users.get().values().stream().filter(u -> !u.getId().equals("system")).collect(Collectors.toList());
    }

    private DataRequest request(String condition, List<Filter> filters) {
        DataRequest request = UserListDatasource.request();
        request.setCondition(condition);
        return request;
    }

    private static DataRequest request() {
        return new DataRequest();
    }
}

