import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiNumber from "alexandria-ui-elements/src/displays/components/Number";
import UiDate from "alexandria-ui-elements/src/displays/components/Date";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import TasksListItemNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import TasksListItemRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TasksListItem extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new TasksListItemNotifier(this);
		this.requester = new TasksListItemRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481" format="catalogIndexReferenceStyle" layout="vertical">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a2063633391" layout="horizontal center">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a2063633391.a906093933" layout="horizontal flexible">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a2063633391.a906093933.a_558519717" format="h4 airRight" mode="normal" value="Loading...">
							</UiText>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a2063633391.a906093933.a_551489544" format="body2 pillStyle" mode="normal" highlighted={{text:"white",background:"#33942F"}}>
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a2063633391.a1230174280" layout="horizontal endjustified">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a2063633391.a1230174280.a_450271209" title="Marcar/Desmarcar como urgente" target="self" mode="MaterialIconButton" icon="Alarm" size="Small" color="#ddd">
							</UiAction>
						</UiBlock>
					</UiBlock>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a_1926994785" format="body2" mode="normal">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a1284819350" label="Responsable" format="body2" mode="normal">
					</UiText>
					<UiNumber context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a1641118558" label="Número de mensajes" format="body2" style="Number" value={0.0} decimals={0} expanded={true}>
					</UiNumber>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a1637862252" format="middleAirTop" layout="horizontal">
						<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a1637862252.a89339239" label="Fecha creación" format="body2 doubleAirRight" pattern="DD/MM/YYYY">
						</UiDate>
						<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1499170481.a1637862252.a_1575805260" label="Fecha actualización" format="body2" pattern="DD/MM/YYYY">
						</UiDate>
					</UiBlock>
				</UiBlock>
			</div>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(TasksListItem));
DisplayFactory.register("TasksListItem", withStyles(styles, { withTheme: true })(withSnackbar(TasksListItem)));