/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.util;

import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.util.LayerHelper;
import java.util.List;
import org.monet.metamodel.ContainerDefinition;
import org.monet.metamodel.DesktopDefinition;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.NodeDefinitionBase;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.components.layers.RoleLayer;
import org.monet.space.kernel.components.layers.TaskLayer;
import org.monet.space.kernel.model.Account;
import org.monet.space.kernel.model.DataRequest;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.NotificationList;
import org.monet.space.kernel.model.Role;
import org.monet.space.kernel.model.RoleList;
import org.monet.space.kernel.model.TaskSearchRequest;

public class AccountHelper {
    public static boolean hasRoles(NodeDefinition definition, UISession session) {
        if (definition instanceof DesktopDefinition) {
            return AccountHelper.hasRoles((DesktopDefinition)definition, session);
        }
        if (definition instanceof ContainerDefinition) {
            return AccountHelper.hasRoles((ContainerDefinition)definition, session);
        }
        return true;
    }

    public static boolean hasRoles(DesktopDefinition definition, UISession session) {
        if (definition.getFor() == null) {
            return true;
        }
        return AccountHelper.hasRoles((List<Ref>)definition.getFor().getRole(), session);
    }

    public static boolean hasRoles(ContainerDefinition definition, UISession session) {
        if (definition.getFor() == null) {
            return true;
        }
        return AccountHelper.hasRoles((List<Ref>)definition.getFor().getRole(), session);
    }

    public static boolean hasRoles(NodeDefinitionBase.OperationProperty operation, UISession session) {
        if (operation == null || operation.getFor() == null) {
            return true;
        }
        return AccountHelper.hasRoles((List<Ref>)operation.getFor().getRole(), session);
    }

    public static boolean hasRoles(List<Ref> roles, UISession session) {
        return AccountHelper.hasRoles(roles, AccountHelper.account(session));
    }

    public static boolean hasRoles(List<Ref> roles, Account account) {
        Dictionary dictionary = Dictionary.getInstance();
        RoleLayer roleLayer = LayerHelper.roleLayer();
        if (roles == null) {
            return false;
        }
        if (roles.isEmpty()) {
            return true;
        }
        return roles.stream().anyMatch(role -> {
            String roleCode = dictionary.getDefinitionCode(role.getValue());
            if (account == null) {
                return false;
            }
            return roleLayer.existsNonExpiredUserRole(roleCode, account.getUser());
        });
    }

    public static NotificationList notificationList(UISession session) {
        return AccountHelper.notificationList(session, 6);
    }

    public static NotificationList notificationList(UISession session, int limit) {
        Account account = AccountHelper.account(session);
        return LayerHelper.notificationLayer().loadNotificationList(account.getUser().getId(), 0, limit);
    }

    public static int activeTaskBoardTasksCount(UISession session) {
        Account account = AccountHelper.account(session);
        TaskLayer taskLayer = LayerHelper.taskLayer();
        TaskSearchRequest request = new TaskSearchRequest();
        request.addParameter("situation", "active");
        request.addParameter("box", "taskboard");
        return taskLayer.searchTasksCount(account, request);
    }

    public static int aliveTaskTrayTasksCount(UISession session) {
        Account account = AccountHelper.account(session);
        TaskLayer taskLayer = LayerHelper.taskLayer();
        TaskSearchRequest request = new TaskSearchRequest();
        request.addParameter("situation", "alive");
        request.addParameter("box", "tasktray");
        return taskLayer.searchTasksCount(account, request);
    }

    public static RoleList loadNonExpiredRoleList(String codeRole, Role.Nature nature) {
        DataRequest dataRequest = new DataRequest();
        dataRequest.setCode(codeRole);
        dataRequest.setStartPos(Integer.valueOf(0));
        dataRequest.setLimit(Integer.valueOf(-1));
        dataRequest.addParameter("nature", nature.toString());
        dataRequest.addParameter("nonexpired", "true");
        return LayerHelper.roleLayer().loadRoleList(dataRequest);
    }

    public static Account account(UISession session) {
        return LayerHelper.federationLayer(session).loadAccount();
    }
}

