/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.TaskListDatasource;
import io.intino.goros.unit.box.ui.displays.rows.TasksTableRow;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTasksTableCatalog;
import io.intino.goros.unit.util.DisplayHelper;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import io.intino.goros.unit.util.TaskHelper;
import java.util.Collections;
import org.monet.space.kernel.model.Task;

public class TasksTableCatalog
extends AbstractTasksTableCatalog<UnitBox> {
    private TaskListDatasource.Inbox inbox;
    private boolean readonly = true;

    public TasksTableCatalog(UnitBox box) {
        super(box);
    }

    public TasksTableCatalog inbox(TaskListDatasource.Inbox inbox) {
        if (this.inbox == inbox) {
            return this;
        }
        this.inbox = inbox;
        this.tasksTable.source((Datasource)new TaskListDatasource((UnitBox)this.box(), this.session(), inbox));
        return this;
    }

    public TasksTableCatalog readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public void select(Task task) {
        DisplayHelper.executeDelayed(b -> this.tasksTable.select(this.tasksTable.findItem(t -> ((Task)t).getId().equals(task.getId()))), 800L);
    }

    public void selectSorting(String sorting, String mode) {
        this.tasksTable.sortings(sorting != null ? Collections.singletonList(NodeHelper.sortingOf(sorting, mode)) : Collections.emptyList());
    }

    public void refresh(Task task) {
        this.tasksTable.refresh(this.tasksTable.findItem(t -> ((Task)t).getId().equals(task.getId())), task);
    }

    @Override
    public void init() {
        super.init();
        this.tasksTable.onAddItem(this::refreshTask);
    }

    private void refreshTask(AddItemEvent event) {
        this.refreshTask((Task)event.item(), (TasksTableRow)event.component());
    }

    private void refreshTask(Task<?> task, TasksTableRow display) {
        display.tasksTableLabelItem.label.value(task.getLabel());
        display.tasksTableLabelItem.state.value(this.translate(TaskHelper.state(task)));
        display.tasksTableLabelItem.state.backgroundColor(TaskHelper.stateColor(task));
        display.tasksTableOwnerItem.owner.value(task.getOwner() != null ? task.getOwner().getInfo().getFullname() : null);
        display.tasksTableCountMessagesItem.countMessages.value(task.getNewMessagesCount());
        display.tasksTableCreateDateItem.createDate.value(task.getInternalCreateDate().toInstant());
        display.tasksTableUpdateDateItem.updateDate.value(task.getInternalUpdateDate().toInstant());
        display.tasksTableOperationsItem.urgent.onExecute(e -> this.toggleUrgent(task, display));
        display.tasksTableOperationsItem.urgent.color(task.isUrgent() ? "#F44335" : "#ddd");
    }

    private void toggleUrgent(Task<?> task, TasksTableRow display) {
        task.setUrgent(!task.isUrgent());
        LayerHelper.taskLayer().saveTaskUrgency(task);
        this.refreshTask(task, display);
    }

    public void refresh() {
        super.refresh();
        this.tasksTable.reload();
    }
}

