/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.TaskListDatasource;
import io.intino.goros.unit.box.ui.displays.items.TasksListItem;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTasksListCatalog;
import io.intino.goros.unit.util.DisplayHelper;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import io.intino.goros.unit.util.TaskHelper;
import java.util.Collections;
import org.monet.space.kernel.model.Task;

public class TasksListCatalog
extends AbstractTasksListCatalog<UnitBox> {
    private TaskListDatasource.Inbox inbox;
    private boolean readonly = true;

    public TasksListCatalog(UnitBox box) {
        super(box);
    }

    public TasksListCatalog inbox(TaskListDatasource.Inbox inbox) {
        if (this.inbox == inbox) {
            return this;
        }
        this.inbox = inbox;
        this.tasksList.source((Datasource)new TaskListDatasource((UnitBox)this.box(), this.session(), inbox));
        return this;
    }

    public TasksListCatalog readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public void select(Task task) {
        DisplayHelper.executeDelayed(b -> this.tasksList.select(this.tasksList.findItem(t -> ((Task)t).getId().equals(task.getId()))), 800L);
    }

    public void selectSorting(String sorting, String mode) {
        this.tasksList.sortings(sorting != null ? Collections.singletonList(NodeHelper.sortingOf(sorting, mode)) : Collections.emptyList());
    }

    public void refresh(Task task) {
        this.tasksList.refresh(this.tasksList.findItem(t -> ((Task)t).getId().equals(task.getId())), task);
    }

    @Override
    public void init() {
        super.init();
        this.tasksList.onAddItem(this::refreshTask);
    }

    private void refreshTask(AddItemEvent event) {
        this.refreshTask((Task)event.item(), (TasksListItem)event.component());
    }

    private void refreshTask(Task<?> task, TasksListItem display) {
        display.label.value(task.getLabel());
        display.state.value(this.translate(TaskHelper.state(task)));
        display.state.backgroundColor(TaskHelper.stateColor(task));
        display.owner.value(task.getOwner() != null ? task.getOwner().getInfo().getFullname() : null);
        display.description.value(task.getDescription());
        display.countMessages.value(task.getNewMessagesCount());
        display.createDate.value(task.getInternalCreateDate().toInstant());
        display.updateDate.value(task.getInternalUpdateDate().toInstant());
        display.urgent.onExecute(e -> this.toggleUrgent(task, display));
        display.urgent.color(task.isUrgent() ? "#F44335" : "#ddd");
    }

    private void toggleUrgent(Task<?> task, TasksListItem display) {
        task.setUrgent(!task.isUrgent());
        LayerHelper.taskLayer().saveTaskUrgency(task);
        this.refreshTask(task, display);
    }

    public void refresh() {
        super.refresh();
        this.tasksList.reload();
    }
}

