/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.model.Column;
import io.intino.goros.unit.box.ui.displays.templates.AbstractNodeDownloadDialogOption;
import java.util.List;
import java.util.function.Consumer;

public class NodeDownloadDialogOption
extends AbstractNodeDownloadDialogOption<UnitBox> {
    private int index;
    private List<Column> columns;
    private Consumer<Column> selectListener;

    public NodeDownloadDialogOption(UnitBox box) {
        super(box);
    }

    public NodeDownloadDialogOption index(int index) {
        this.index = index;
        return this;
    }

    public NodeDownloadDialogOption columns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public NodeDownloadDialogOption onSelect(Consumer<Column> listener) {
        this.selectListener = listener;
        return this;
    }

    public Column selectedColumn() {
        String option = this.options.selection().size() > 0 ? (String)this.options.selection().get(0) : null;
        option = option != null && option.equals(this.translate("None")) ? null : option;
        return this.findColumn(option);
    }

    private Column findColumn(String option) {
        if (option == null) {
            return null;
        }
        return this.columns.stream().filter(c -> c.label().equals(option)).findFirst().orElse(null);
    }

    @Override
    public void init() {
        super.init();
        this.options.onSelect(e -> this.notifySelect());
    }

    public void refresh() {
        super.refresh();
        this.name.value(this.translate("Column") + " " + (this.index + 1));
        this.options.add(this.translate("None"));
        this.columns.forEach(o -> this.options.add(o.label()));
    }

    private void notifySelect() {
        this.selectListener.accept(this.selectedColumn());
    }
}

