/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.SetDefinition;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.NodeDataRequest;

public class CollectionDatasource
extends PageDatasource<Node> {
    private final UnitBox box;
    private final UISession session;
    private final Node set;
    private final NodeViewProperty view;

    public CollectionDatasource(UnitBox box, UISession session, Node set, String view) {
        this.box = box;
        this.session = session;
        this.set = set;
        this.view = set.getDefinition().getNodeView(view);
    }

    public List<Node> items(int start, int count, String condition, List<Filter> filters, List<String> sortings) {
        NodeDataRequest request = this.request(condition, filters, sortings);
        request.setStartPos(Integer.valueOf(start));
        request.setLimit(Integer.valueOf(count));
        this.box.linkSession(this.session);
        return new ArrayList<Node>(LayerHelper.nodeLayer().requestNodeListItems(this.set.getId(), request).values());
    }

    public long itemCount(String condition, List<Filter> filters) {
        this.box.linkSession(this.session);
        return LayerHelper.nodeLayer().requestNodeListItemsCount(this.set.getId(), this.request(condition, filters));
    }

    public List<Group> groups(String key) {
        List groups = this.set.getGroupOptions(key, Collections.emptyList(), Collections.emptyList());
        return groups.stream().map(o -> new Group().label(o)).collect(Collectors.toList());
    }

    public static long itemCount(Node set) {
        return LayerHelper.nodeLayer().requestNodeListItemsCount(set.getId(), CollectionDatasource.request(set));
    }

    private NodeDataRequest request(String condition, List<Filter> filters) {
        return this.request(condition, filters, Collections.emptyList());
    }

    private NodeDataRequest request(String condition, List<Filter> filters, List<String> sortings) {
        boolean filterByTitle = this.filterByTitle(filters);
        NodeDataRequest request = CollectionDatasource.request(this.set);
        request.setCondition(condition);
        if (filterByTitle) {
            request.setConditionTag("title");
        }
        request.setGroupsBy(NodeHelper.groupsByOf(filters).stream().filter(g -> !g.attribute().equals("titleTag")).collect(Collectors.toList()));
        request.setSortsBy(NodeHelper.sortsByOf(sortings));
        request.setCodeView(this.view.getCode());
        return request;
    }

    private boolean filterByTitle(List<Filter> filters) {
        Filter titleFilter = filters.stream().filter(f -> f.grouping().equalsIgnoreCase("titleTag")).findFirst().orElse(null);
        return titleFilter != null;
    }

    private static NodeDataRequest request(Node set) {
        NodeDataRequest request = new NodeDataRequest();
        request.setCodeDomainNode(set.getCode());
        request.setCodeReference(Dictionary.getInstance().getDefinitionCode(((SetDefinition)set.getDefinition()).getIndex().getValue()));
        return request;
    }
}

