/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.printers;

import io.intino.alexandria.logger.Logger;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.printers.Printer;
import io.intino.goros.unit.printers.templates.CsvNodeTemplate;
import io.intino.goros.unit.printers.templates.PdfNodeTemplate;
import io.intino.goros.unit.printers.templates.XlsNodeTemplate;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.monet.space.kernel.library.LibraryPDF;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.NodeDataRequest;

public abstract class NodePrinter
extends Printer {
    protected final UnitBox box;
    protected final Node node;
    protected final NodeDataRequest request;
    protected final String format;
    protected final List<String> columns;

    public NodePrinter(UnitBox box, Node node, NodeDataRequest request, String format, List<String> columns) {
        this.box = box;
        this.node = node;
        this.request = request;
        this.format = format;
        this.columns = columns;
    }

    public InputStream print(String language) {
        Template template = this.template();
        String result = template.render((Object)this.build(language).toFrame());
        return new ByteArrayInputStream(this.generateDocument(result));
    }

    protected abstract FrameBuilder build(String var1);

    protected FrameBuilder baseFrame() {
        return new FrameBuilder();
    }

    private Template template() {
        if (this.format.equalsIgnoreCase("pdf")) {
            return new PdfNodeTemplate();
        }
        if (this.format.equalsIgnoreCase("xls")) {
            return new XlsNodeTemplate();
        }
        return new CsvNodeTemplate();
    }

    protected byte[] generateDocument(String result) {
        try {
            if (this.format.equalsIgnoreCase("pdf")) {
                return LibraryPDF.create((InputStream)new ByteArrayInputStream(result.getBytes("utf8"))).toByteArray();
            }
            if (this.format.equalsIgnoreCase("xls")) {
                return result.replaceAll("\\\\n", "\r\n").getBytes("UTF-8");
            }
            return result.replaceAll("\\\\n", "\r\n").getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error((Throwable)e);
            return new byte[0];
        }
    }
}

