/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.FormDatasource;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTaskOrderTemplate;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.NodeHelper;
import java.time.Instant;
import java.util.function.Consumer;
import org.monet.bpi.FieldBoolean;
import org.monet.bpi.FieldDate;
import org.monet.bpi.FieldMemo;
import org.monet.bpi.types.Date;
import org.monet.space.kernel.model.Node;

public class TaskOrderTemplate
extends AbstractTaskOrderTemplate<UnitBox> {
    private Node node;
    private FieldDate suggestedStartDateField;
    private FieldDate suggestedEndDateField;
    private FieldMemo commentsField;
    private FieldBoolean urgentField;

    public TaskOrderTemplate(UnitBox box) {
        super(box);
    }

    public TaskOrderTemplate node(Node node) {
        this.node = node;
        this.updateFields();
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.suggestedStartDate.onChange(e -> this.save(b -> this.suggestedStartDateField.set((Object)new Date(((Instant)e.value()).toEpochMilli()))));
        this.suggestedEndDate.onChange(e -> this.save(b -> this.suggestedEndDateField.set((Object)new Date(((Instant)e.value()).toEpochMilli()))));
        this.comments.onChange(e -> this.save(b -> this.commentsField.set((Object)((String)e.value()))));
        this.urgent.onToggle(e -> this.save(b -> this.urgentField.set((Object)(e.state() == ToggleEvent.State.On ? 1 : 0))));
    }

    public void refresh() {
        super.refresh();
        this.suggestedStartDate.value(NodeHelper.instantOf(this.suggestedStartDateField));
        this.suggestedEndDate.value(NodeHelper.instantOf(this.suggestedEndDateField));
        this.comments.value((String)this.commentsField.get());
        this.urgent.state(this.urgentField.isChecked() ? ToggleEvent.State.On : ToggleEvent.State.Off);
    }

    private void save(Consumer<Boolean> consumer) {
        consumer.accept(true);
        LayerHelper.nodeLayer().saveNode(this.node);
        this.updateFields();
    }

    private void updateFields() {
        FormDatasource datasource = new FormDatasource((UnitBox)this.box(), this.session(), this.node);
        this.suggestedStartDateField = (FieldDate)datasource.getField("_vrwtkw");
        this.suggestedEndDateField = (FieldDate)datasource.getField("_7vewhg");
        this.commentsField = (FieldMemo)datasource.getField("_y__kmq");
        this.urgentField = (FieldBoolean)datasource.getField("_ss7omw");
    }
}

