package io.intino.goros.unit.box;

import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.goros.unit.box.rest.resources.*;
import io.intino.alexandria.core.Box;

public class MobileServiceService {

	public static AlexandriaSpark setup(AlexandriaSpark server, UnitBox box) {
		server.route("mobile/api/Helo/").post(manager -> new PostHeloResource(box, manager).execute());
		server.route("mobile/api/Register/").post(manager -> new PostRegisterResource(box, manager).execute());
		server.route("mobile/api/Unregister/").post(manager -> new PostUnregisterResource(box, manager).execute());
		server.route("mobile/api/LoadNewDefinitions/").post(manager -> new PostLoadNewDefinitionsResource(box, manager).execute());
		server.route("mobile/api/LoadNewGlossaries/").post(manager -> new PostLoadNewGlossariesResource(box, manager).execute());
		server.route("mobile/api/DownloadGlossary/").post(manager -> new PostDownloadGlossaryResource(box, manager).execute());
		server.route("mobile/api/LoadNewAssignedTasks/").post(manager -> new PostLoadNewAssignedTasksResource(box, manager).execute());
		server.route("mobile/api/LoadNewAvailableTasks/").post(manager -> new PostLoadNewAvailableTasksResource(box, manager).execute());
		server.route("mobile/api/LoadAssignedTasksToDelete/").post(manager -> new PostLoadAssignedTasksToDeleteResource(box, manager).execute());
		server.route("mobile/api/LoadFinishedTasksToDelete/").post(manager -> new PostLoadFinishedTasksToDeleteResource(box, manager).execute());
		server.route("mobile/api/LoadUnassignedTasksToDelete/").post(manager -> new PostLoadUnassignedTasksToDeleteResource(box, manager).execute());
		server.route("mobile/api/AssignTask/").post(manager -> new PostAssignTaskResource(box, manager).execute());
		server.route("mobile/api/UnassignTask/").post(manager -> new PostUnassignTaskResource(box, manager).execute());
		server.route("mobile/api/DownloadTaskPacked/").post(manager -> new PostDownloadTaskPackedResource(box, manager).execute());
		server.route("mobile/api/UploadTaskPacked/").post(manager -> new PostUploadTaskPackedResource(box, manager).execute());
		server.route("mobile/api/PrepareUploadTask/").post(manager -> new PostPrepareUploadTaskResource(box, manager).execute());
		server.route("mobile/api/UploadTaskFile/:id/:extra/").post(manager -> new PostUploadTaskFileResource(box, manager).execute());
		server.route("mobile/api/UploadTaskSchema/:id/").post(manager -> new PostUploadTaskSchemaResource(box, manager).execute());
		server.route("mobile/api/SyncChats/").post(manager -> new PostSyncChatsResource(box, manager).execute());

		return server;
	}
}