package io.intino.goros.unit.box;

import io.intino.alexandria.ui.services.translator.Dictionary;

import java.util.HashMap;
import java.util.Map;
import java.util.ArrayList;
import java.util.List;

public class I18n {
	private static Map<String, Dictionary> dictionaries = new HashMap<>();

	public static String translate(String word, String language) {
		language = dictionaries.containsKey(language) ? language : "en";
		Dictionary dictionary = dictionaries.get(language);
		return dictionary != null && dictionary.containsKey(word) ? dictionary.get(word) : word;
	}

    public static List<Dictionary> dictionaries() {
        return new ArrayList<>(dictionaries.values());
    }

	static {
		dictionaries.put("es", new Dictionary() {{
			put("Affirm", "Confirmar");
			put("Search...", "Buscar...");
			put("Loading...", "Cargando...");
			put("Cancel", "Cancelar");
			put("OK", "Aceptar");
			put("Tasks", "Tareas");
			put("My tasks", "Mis tareas");
			put("results", "resultados");
			put("one result", "un resultado");
			put("no results", "no hay resultados");
			put("Back", "Anterior");
			put("Next", "Siguiente");
			put("Drag and drop a file here or click", "Arrastre y suelte un archivo aquí o haga click");
			put("Remove location", "Quitar ubicación");
			put("goto space", "ir al espacio");
			put("available", "disponibles");
			put("deleted", "borrados");
			put("Sending to selected provider...", "Enviando al proveedor seleccionado...");
			put("Sending to selected worker...", "Enviando al trabajador seleccionado...");
			put("New", "Nueva");
			put("Pending", "Pendiente");
			put("Waiting", "En espera");
			put("Expired", "Caducado");
			put("Non expired", "Activo");
			put("Finished", "Finalizada");
			put("Aborted", "Abortada");
			put("Failure", "Error");
			put("Are you sure you want continue with task?", "¿Está seguro/a que quiere continuar con la tarea?");
			put("Folder", "Directorio");
			put("Urgents", "Urgentes");
			put("Nature", "Naturaleza");
			put("Task", "Tarea");
			put("Tasks", "Tareas");
			put("History", "Histórico");
			put("by", "por");
			put("Task is", "La tarea está");
			put("Continue", "Continuar");
			put("No form defined", "No se ha definido ningún formulario");
			put("It could not solve task edition", "No se puede resolver la edición del elemento");
			put("Are you sure to unassign task?", "¿Está seguro/a que desea desasignar la tarea?");
			put("Are you sure to abort task?", "¿Está seguro/a que desea abortar la tarea?");
			put("pospone one hour", "aplazar una hora");
			put("define for next hour", "definir para la próxima hora");
			put("pospone one day", "aplazar un día");
			put("define for next day", "definir para el próximo día");
			put("pospone one month", "aplazar un mes");
			put("define for next month", "definir para el próximo mes");
			put("pospone one year", "aplazar un año");
			put("define for next year", "definir para el próximo año");
			put("don't pospone", "no esperar más");
			put("Due date is", "La fecha de vencimiento es");
			put("Due date not defined", "No se ha definido una fecha de vencimiento");
			put("No external/internal provider defined. Contact with administrator", "No se ha definido ningún proveedor externo/interno. Contacte con el administrador");
			put("No roles of type ::role:: defined for delegation", "No se ha encontrado ningún role de tipo ::role:: que permita realizar esta acción");
			put("No roles of type ::role:: defined for job", "No se ha encontrado ningún role de tipo ::role:: que permita realizar el trabajo");
			put("Select client to whom send order:", "Selecciona el cliente al cual enviar el encargo:");
			put("Select user to whom send order:", "Selecciona el usuario al cual enviar el encargo:");
			put("Setup order for ::role::", "Configura el encargo que se enviará a ::role::");
			put("Sending order...", "Enviando encargo...");
			put("Trying to send order. Last sent request was at", "Intentando enviar el encargo. El último intento de envío fue realizado el");
			put("Trying to send order.", "Intentando enviar el encargo.");
			put("Suggested start date", "Fecha de inicio propuesta");
			put("Suggested end date", "Fecha de fin propuesta");
			put("Comments", "Observaciones");
			put("Urgent", "Urgente");
			put("Sending request. Please, wait...", "Enviando solicitud. Por favor, espere...");
			put("There was an attempt to send a request that failed", "Hubo un intento de envío de una solicitud que falló");
			put("Sending response. Please, wait...", "Enviando respuesta. Por favor, espere...");
			put("There was an attempt to send a response that failed", "Hubo un intento de envío de una respuesta que falló");
			put("Retry", "Reintentar");
			put("Unassigned", "Sin asignar");
			put("No pending tasks", "No hay tareas pendientes");
			put("::owner:: is doing job", "::owner:: está haciendo el trabajo");
			put("Job is finished", "El trabajo ha terminado");
			put("Job is aborted", "El trabajo ha sido abortado");
			put("Job is pending to be assigned to user", "El trabajo está pendiente de ser asignado");
			put("No pending tasks", "No tiene tareas pendientes");
			put("Tasks", "Tareas");
			put("News", "Noticias");
			put("Roles", "Roles");
			put("Trash", "Papelera");
			put("Fullname", "Nombre completo");
			put("Email", "Dirección de correo");
			put("Reason", "Motivo");
			put("Assign task ::title:: to user...", "Asignar la tarea ::title:: al usuario...");
			put("No roles", "No hay roles");
			put("Download", "Descargar");
			put("Class", "Clase");
			put("Select class", "Indique la clase");
			put("User", "Usuario");
			put("Type", "Tipo");
			put("All types", "Todos los tipos");
			put("Select type", "Indique el tipo");
			put("Start date", "Fecha de inicio");
			put("End date", "Fecha de expiración");
			put("Select class to add role", "Indique una clase para añadir el role");
			put("Select type to add role", "Indique un tipo para añadir el role");
			put("Begin date must be filled", "Se debe indicar la fecha de comienzo");
			put("Add role", "Añadir role");
			put("Add", "Añadir");
			put("Remove", "Eliminar");
			put("Select user to add role", "Seleccione un usuario para añadir el role");
			put("Select service partner to add role", "Seleccione un proveedor de servicios para añadir el role");
			put("Select feeder partner to add role", "Seleccione un proveedor de fuente de datos para añadir el role");
			put("Role ::role:: is already active for ::user::", "Role ::role:: ya está en activo para el usuario ::user::");
			put("No users", "No hay usuarios");
			put("No service partners available", "No hay proveedores de servicios disponibles");
			put("No feeder partners available", "No hay proveedores de fuente de datos disponibles");
			put("Name", "Nombre");
			put("Partner", "Proveedor");
			put("Class", "Clase");
			put("Role is expired since ::endDate::", "El role ha expirado desde el ::endDate::");
			put("Role is active since ::startDate:: and no expires", "El role está activo desde el ::startDate:: y no expira");
			put("Role is active since ::startDate:: and expires at ::endDate::", "El role está activo desde el ::startDate:: y expira el ::endDate::");
			put("Finish edition", "Finalizar edición");
			put("Edit", "Editar");
			put("Are you sure to revoke role?", "¿Está seguro/a que desea revocar el role?");
			put("Term", "Término");
			put("Terms", "Términos");
			put("Tags count", "Número de marcadores");
			put("Category", "Categoría");
			put("Selectable", "Seleccionable");
			put("Term", "Término");
			put("Code", "Código");
			put("Title", "Título");
			put("Label", "Etiqueta");
			put("Delete date", "Fecha eliminado");
			put("Contain other terms", "Contiene otros términos");
			put("Tags", "Etiquetas");
			put("No tags", "No hay etiquetas");
			put("Add to", "Añadir a");
			put("Add term", "Añadir término");
			put("Add tag", "Añadir etiqueta");
			put("Fill name and label", "Rellene el nombre y la etiqueta");
			put("Value", "Valor");
			put("Name cannot be empty", "El nombre no puede quedar vacío");
			put("Term already exists", "Término en uso");
			put("Term already exists, select other code", "El término ya existe, indique otro código");
			put("New terms added recently that are not published yet", "Ha añadido recientemente nuevos términos pero no han sido publicados");
			put("Delete", "Borrar");
			put("Enable", "Habilitar");
			put("Disable", "Deshabilitar");
			put("Publish", "Publicar");
			put("Publish all", "Publicar todos");
			put("Terms published", "Los términos han sido publicados");
			put("No element defined", "No se ha creado el elemento");
			put("Add element", "Añadir elemento");
			put("Select element type", "Seleccione el tipo de elemento");
			put("Download document", "Descargar documento");
			put("Download document to edit it in your computer.", "Descargue el documento para poder realizar la edición en su ordenador.");
			put("Click next if you have already edit the document.", "Haga click en siguiente si ya ha editado el documento.");
			put("Edit document", "Editar documento");
			put("Open the document and insert the changes that you want.", "Abra el documento e introduzca los cambios que desee.");
			put("When you finish, indicate the location of the modified document to save the last version in the system.", "Cuando termine, indique la localización del documento modificado para guardar la última versión en el sistema.");
			put("Document saved", "Documento guardado");
			put("New version of document received.", "Se ha recibido la nueva versión del documento.");
			put("Click save to replace current version.", "Haga click en guardar para reemplazar la versión actual.");
			put("Modify document", "Modificar documento");
			put("Save", "Guardar");
			put("Document saved successfully", "El documento ha sido guardado correctamente");
			put("Could not save new location", "No se ha podido guardar la nueva ubicación");
			put("No elements", "No hay elementos");
			put("Reset filters", "Resetear filtros");
			put("Filter", "Filtrar");
			put("Element", "Elemento");
			put("Restore element?", "Recuperar elemento");
			put("Are you sure you want to restore element from trash?", "¿Está seguro/a que desea recuperar el elemento de la papelera?");
			put("Are you sure you want to restore all elements?", "¿Está seguro/a que desea recuperar todos los elementos de la papelera?");
			put("Restore", "Recuperar");
			put("Empty trash", "Vaciar papelera");
			put("Are you sure you want to empty the trash?", "¿Está seguro/a que desea vaciar la papelera?");
			put("Are you sure you want to remove selection?", "¿Está seguro/a que desea eliminar la selección?");
			put("Are you sure you want to remove element?", "¿Está seguro/a que desea eliminar el elemento?");
			put("Task is assigned to %s", "La tarea está asignada a %s");
			put("Task is not assigned", "La tarea no está asignada");
			put("Business units", "Unidades de negocio");
			put("(current)", "(actual)");
			put("Operation executed", "Operación ejecutada");
			put("Column", "Columna");
			put("Select column", "Seleccione una columna");
			put("None", "Ninguna");
			put("Downloading data...", "Descargando datos...");
			put("Download finished", "Descarga finalizada");
			put("Condition", "Condición");
			put("Page", "Página");
			put("Filters", "Filtros");
			put("Unassigning task...", "Desasignando tarea...");
			put("Task unassigned", "Tarea desasignada");
			put("Assigning task...", "Asignando tarea...");
			put("Task asigned", "Tarea asignada");
			put("Setting up delegation...", "Configurando delegación...");
			put("Delegation setup", "Delegación configurada");
			put("Setting up job...", "Configurando trabajo...");
			put("Job setup", "Trabajo configurado");
			put("Resolving task...", "Avanzando tarea...");
			put("Task resolved", "Tarea avanzada");
			put("Restricted information", "Información restringida");
			put("active task", "tarea activa");
			put("active tasks", "tareas activas");
			put("pending task", "tarea pendiente");
			put("pending tasks", "tareas pendientes");
			put("You don't have permissions in this service", "No tiene permisos en este servicio");
			put("Open", "Abrir");
			put("No label", "Sin etiqueta");
			put("Service order", "Solicitud");
			put("Service response", "Respuesta");
			put("Info", "Info");
			put("Business model updated", "Sistema");
			put("Business model installed", "Sistema");
			put("User post", "Post usuario");
			put("No title", "Sin título");
			put("Created at", "Creado el");
			put("by", "por");
			put("Active", "Activa");
			put("Pending", "Pendiente");
			put("Expired", "Expirada");
			put("Finished", "Finalizada");
			put("Aborted", "Abortada");
			put("Failure", "Con error");
			put("Yes", "Sí");
			put("No", "No");
		}}.language("es"));
	}
}