/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractSourceTemplate;
import io.intino.goros.unit.util.Formatters;
import io.intino.goros.unit.util.SourceHelper;
import org.monet.metamodel.SourceDefinition;
import org.monet.space.kernel.model.Source;

public class SourceTemplate
extends AbstractSourceTemplate<UnitBox> {
    private String desktopLabel;
    private String desktopPath;
    private Source<SourceDefinition> source;

    public SourceTemplate(UnitBox box) {
        super(box);
    }

    public SourceTemplate desktop(String label, String path) {
        this.desktopLabel = label;
        this.desktopPath = path;
        return this;
    }

    public SourceTemplate open(String key) {
        this.source = SourceHelper.locateSource(key);
        this.refresh();
        return this;
    }

    public void refresh() {
        super.refresh();
        this.desktopLink.title(this.desktopLabel);
        this.desktopLink.address(path -> this.desktopPath);
        this.desktopLink.visible(this.desktopPath != null);
        this.desktopLinkSeparator.visible(this.desktopPath != null);
        this.label.value(this.source.getLabel());
        this.content.onTermsCountChange(this::refreshCount);
        this.content.source(this.source);
        this.content.refresh();
    }

    private void refreshCount(long countValue) {
        this.count.value(Formatters.countMessage(countValue, this.translate("Term").toLowerCase(), this.translate("Terms").toLowerCase()));
    }
}

