/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractSearchFilterTemplate;
import java.util.Collections;

public class SearchFilterTemplate
extends AbstractSearchFilterTemplate<UnitBox> {
    private String _label;
    private String attribute;
    private Collection collection;
    private boolean applyFilters = true;

    public SearchFilterTemplate(UnitBox box) {
        super(box);
    }

    public SearchFilterTemplate label(String label) {
        this._label = label;
        return this;
    }

    public SearchFilterTemplate attribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    public SearchFilterTemplate bindTo(Collection collection) {
        this.collection = collection;
        return this;
    }

    public void clearSelection() {
        this.applyFilters = false;
        this.search.value(null);
        this.applyFilters = true;
    }

    @Override
    public void init() {
        super.init();
        this.search.onEnterPress(e -> this.filter());
    }

    public void refresh() {
        super.refresh();
        this.label.value(this._label + ":");
    }

    private void filter() {
        if (!this.applyFilters) {
            return;
        }
        String value = this.search.value();
        if (value == null || value.isEmpty()) {
            this.collection.removeFilter(this.attribute);
        } else {
            this.collection.filter(this.attribute, Collections.singletonList(value));
        }
    }
}

