/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.NodeRevisionsDatasource;
import io.intino.goros.unit.box.ui.displays.rows.NodeRevisionsTableRow;
import io.intino.goros.unit.box.ui.displays.templates.AbstractNodeRevisionsTemplate;
import io.intino.goros.unit.util.DictionaryHelper;
import io.intino.goros.unit.util.LayerHelper;
import java.util.function.Consumer;
import org.monet.metamodel.NodeViewProperty;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.Revision;

public class NodeRevisionsTemplate
extends AbstractNodeRevisionsTemplate<UnitBox> {
    private Node node;
    private NodeViewProperty view;
    private Consumer<Revision> selectListener;
    private boolean readonly = true;

    public NodeRevisionsTemplate(UnitBox box) {
        super(box);
    }

    public NodeRevisionsTemplate node(Node node) {
        this.node = node;
        return this;
    }

    public NodeRevisionsTemplate view(String view) {
        this.view = view != null ? DictionaryHelper.view(this.node, view) : null;
        return this;
    }

    public NodeRevisionsTemplate readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public NodeRevisionsTemplate onSelect(Consumer<Revision> listener) {
        this.selectListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.nodeRevisionsTable.onSelect(e -> this.selectListener.accept((Revision)e.selection().get(0)));
        this.nodeRevisionsTable.onAddItem(e -> {
            Revision revision = (Revision)e.item();
            NodeRevisionsTableRow row = (NodeRevisionsTableRow)e.component();
            row.nodeRevisionsTableLabelItem.label.value(revision.getRevisionDate().toInstant());
            row.nodeRevisionsTableOperationsItem.restore.readonly(this.readonly);
            row.nodeRevisionsTableOperationsItem.restore.onExecute(e1 -> this.restore(revision));
        });
    }

    public void refresh() {
        super.refresh();
        this.nodeRevisionsTable.source((Datasource)new NodeRevisionsDatasource((UnitBox)this.box(), this.session(), this.node, this.view));
        this.nodeRevisionsTable.reload();
    }

    private void restore(Revision revision) {
        LayerHelper.nodeLayer().restoreNode(revision);
        ((TemplateNotifier)this.notifier).redirect(this.session().browser().requestUrl());
    }
}

