/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.util.LayerHelper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.monet.metamodel.FieldProperty;
import org.monet.metamodel.FormDefinition;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.LinkFieldProperty;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.NodeDataRequest;
import org.monet.space.kernel.model.NodeItem;

public class FieldLinkDatasource
extends PageDatasource<NodeItem> {
    private final UnitBox box;
    private final UISession session;
    private final Node form;
    private final LinkFieldProperty definition;
    private final IndexDefinition indexDefinition;

    public FieldLinkDatasource(UnitBox box, UISession session, String fieldCode, Node<?> form, IndexDefinition indexDefinition) {
        this.box = box;
        this.session = session;
        this.form = form;
        this.definition = (LinkFieldProperty)((FormDefinition)form.getDefinition()).getField(fieldCode);
        this.indexDefinition = indexDefinition;
    }

    public List<NodeItem> items(int start, int count, String condition, List<Filter> filters, List<String> sortings) {
        NodeDataRequest request = this.request(condition, filters);
        request.setStartPos(Integer.valueOf(start));
        request.setLimit(Integer.valueOf(count));
        this.box.linkSession(this.session);
        return new ArrayList<NodeItem>(LayerHelper.nodeLayer().searchLinkNodeItems(request).get().values());
    }

    public long itemCount(String condition, List<Filter> filters) {
        this.box.linkSession(this.session);
        return LayerHelper.nodeLayer().searchLinkNodeItems(this.request(condition, filters)).getTotalCount();
    }

    public List<Group> groups(String key) {
        return Collections.emptyList();
    }

    private NodeDataRequest request(String condition, List<Filter> filters) {
        NodeDataRequest request = FieldLinkDatasource.request();
        request.setCondition(condition);
        request.setCodeDomainNode(this.indexDefinition.getCode());
        this.addFilters(request);
        return request;
    }

    private void addFilters(NodeDataRequest request) {
        if (this.definition.getSource() == null) {
            return;
        }
        LinkFieldProperty.SourceProperty source = this.definition.getSource();
        ArrayList filterList = source.getFilterList();
        final HashMap<String, CallSite> filters = new HashMap<String, CallSite>();
        for (LinkFieldProperty.SourceProperty.FilterProperty filterDefinition : filterList) {
            Object value = filterDefinition.getValue();
            String attributeName = filterDefinition.getAttribute().getValue();
            String operator = filterDefinition.getOperator() != null ? filterDefinition.getOperator().toString() : LinkFieldProperty.SourceProperty.FilterProperty.OperatorEnumeration.EQUALS.toString();
            String filterValue = "";
            if (value instanceof String) {
                filterValue = (String)value;
            } else if (value instanceof Ref) {
                filterValue = this.form.getFieldValue(this.fieldDefinition(((Ref)value).getValue()).getCode());
            }
            if (filterValue == null || filterValue.isEmpty()) continue;
            filters.put(this.indexDefinition.getAttribute(attributeName).getCode(), (CallSite)((Object)(filterValue + "__" + operator)));
        }
        if (filters.isEmpty()) {
            return;
        }
        request.setParameters((HashMap)new HashMap<String, String>(){
            {
                this.put("filters", FieldLinkDatasource.this.serialize(filters));
            }
        });
    }

    private String serialize(Map<String, String> filters) {
        return filters.entrySet().stream().map(f -> (String)f.getKey() + "=" + (String)f.getValue()).collect(Collectors.joining("#"));
    }

    private FieldProperty fieldDefinition(String key) {
        return ((FormDefinition)this.form.getDefinition()).getField(key);
    }

    private static NodeDataRequest request() {
        return new NodeDataRequest();
    }
}

