/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractCheckFilterTemplate;
import java.util.Collections;

public class CheckFilterTemplate
extends AbstractCheckFilterTemplate<UnitBox> {
    private String _label;
    private String attribute;
    private Collection collection;
    private boolean applyFilters = true;

    public CheckFilterTemplate(UnitBox box) {
        super(box);
    }

    public CheckFilterTemplate label(String label) {
        this._label = label;
        return this;
    }

    public CheckFilterTemplate attribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    public CheckFilterTemplate bindTo(Collection collection) {
        this.collection = collection;
        return this;
    }

    public void checked(boolean value) {
        if (value) {
            this.selector.select(new String[]{this._label});
        } else {
            this.selector.select(new String[0]);
        }
    }

    public void clearSelection() {
        this.applyFilters = false;
        this.selector.select(new String[0]);
        this.applyFilters = true;
    }

    @Override
    public void init() {
        super.init();
        this.selector.onSelect(e -> {
            if (!this.applyFilters) {
                return;
            }
            if (e.selection().size() > 0) {
                this.collection.filter(this.attribute, Collections.singletonList(this.attribute));
            } else {
                this.collection.removeFilter(this.attribute);
            }
        });
    }

    public void refresh() {
        super.refresh();
        this.selector.add(this._label);
    }
}

